/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.cls;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tencentcloudapi.cls.v20201016.ClsClient;
import com.tencentcloudapi.cls.v20201016.models.DescribeTopicsRequest;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.cls.ClsDataNodeDTO;
import org.apache.inlong.manager.pojo.node.cls.ClsDataNodeInfo;
import org.apache.inlong.manager.pojo.node.cls.ClsDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClsDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClsDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        ClsDataNodeRequest clsDataNodeRequest = (ClsDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)clsDataNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            ClsDataNodeDTO dto = ClsDataNodeDTO.getFromRequest((ClsDataNodeRequest)clsDataNodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for Cloud log service node: %s", e.getMessage()));
        }
    }

    @Override
    public Boolean accept(String dataNodeType) {
        return "CLS".equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "CLS";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        ClsDataNodeInfo info = new ClsDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)info);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            ClsDataNodeDTO dto = ClsDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)info);
        }
        return info;
    }

    @Override
    public Boolean testConnection(DataNodeRequest request) {
        ClsDataNodeRequest dataNodeRequest = (ClsDataNodeRequest)request;
        Credential cred = new Credential(dataNodeRequest.getManageSecretId(), dataNodeRequest.getManageSecretId());
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint(dataNodeRequest.getEndpoint());
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setHttpProfile(httpProfile);
        ClsClient client = new ClsClient(cred, dataNodeRequest.getRegion(), clientProfile);
        DescribeTopicsRequest req = new DescribeTopicsRequest();
        try {
            client.DescribeTopics(req);
        }
        catch (TencentCloudSDKException e) {
            String errMsg = String.format("connect tencent cloud error endPoint = %s secretId = %s secretKey = %s", dataNodeRequest.getEndpoint(), dataNodeRequest.getManageSecretId(), dataNodeRequest.getManageSecretKey());
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
        return true;
    }
}

