/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.sqlserver;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerColumnInfo;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerSqlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLServerSqlBuilder.class);

    public static String getCheckTable(String schemaName, String tableName) {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT COUNT(1) ").append(" FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '").append(schemaName).append("' AND TABLE_NAME = '").append(tableName).append("' ;");
        LOGGER.info("check table sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static String getCheckColumn(String schemaName, String tableName, String columnName) {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT COUNT(1) ").append(" FROM  INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA='").append(schemaName).append("' AND TABLE_NAME = '").append(tableName).append("' AND COLUMN_NAME = '").append(columnName).append("';");
        LOGGER.info("check table sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static String getCheckSchema(String schemaName) {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT COUNT(1) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME ='").append(schemaName).append("';");
        LOGGER.info("check schema sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static String buildCreateSchemaSql(String schemaName) {
        return "CREATE SCHEMA \"" + schemaName + "\" AUTHORIZATION dbo ;";
    }

    public static List<String> buildCreateTableSql(SQLServerTableInfo table) {
        ArrayList sqls = Lists.newArrayList();
        StringBuilder sql = new StringBuilder().append("CREATE TABLE ").append(table.getSchemaName()).append(".").append(table.getTableName()).append(SQLServerSqlBuilder.buildCreateColumnsSql(table));
        sqls.add(sql.toString());
        table.getColumns().stream().filter(column -> StringUtils.isNotEmpty((CharSequence)column.getComment())).forEach(column -> sqls.add(SQLServerSqlBuilder.buildAddColumnComment(table.getSchemaName(), table.getTableName(), column.getName(), column.getComment())));
        LOGGER.info("create table sql: {}", (Object)sqls);
        return sqls;
    }

    public static List<String> buildAddColumnsSql(String schemaName, String tableName, List<SQLServerColumnInfo> columnList) {
        ArrayList sqls = Lists.newArrayList();
        List<String> columnInfoList = SQLServerSqlBuilder.getColumnsInfo(columnList, null);
        StringBuilder sqlBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(columnList)) {
            sqlBuilder.append("ALTER TABLE ").append(schemaName).append(".").append(tableName).append(" ADD ").append(String.join((CharSequence)",", columnInfoList)).append(" ;");
        }
        sqls.add(sqlBuilder.toString());
        columnList.stream().filter(column -> StringUtils.isNotEmpty((CharSequence)column.getComment())).forEach(column -> sqls.add(SQLServerSqlBuilder.buildAddColumnComment(schemaName, tableName, column.getName(), column.getComment())));
        LOGGER.info("add columns sql={}", (Object)sqls);
        return sqls;
    }

    private static String buildAddColumnComment(String schemaName, String tableName, String columnName, String comment) {
        return "EXEC sys.sp_addextendedproperty @name=N'MS_Description'," + " @value=N'" + columnName + "' , @level0type=N'SCHEMA',@level0name=N'" + schemaName + "', @level1type=N'TABLE',@level1name=N'" + tableName + "', @level2type=N'COLUMN',@level2name=N'" + comment + "'";
    }

    private static String buildCreateColumnsSql(SQLServerTableInfo table) {
        StringBuilder sqlBuilder = new StringBuilder().append(" (").append(String.join((CharSequence)",", SQLServerSqlBuilder.getColumnsInfo(table.getColumns(), table.getPrimaryKey()))).append(") ");
        LOGGER.info("create columns sql={}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    private static List<String> getColumnsInfo(List<SQLServerColumnInfo> columns, String primaryKey) {
        ArrayList columnList = Lists.newArrayList();
        StringBuilder columnBuilder = new StringBuilder();
        columns.forEach(columnInfo -> {
            columnBuilder.append("\"").append(columnInfo.getName()).append("\"").append(" ").append(columnInfo.getType()).append(" ");
            if (StringUtils.isNotEmpty((CharSequence)primaryKey) && columnInfo.getName().equals(primaryKey)) {
                columnBuilder.append("PRIMARY KEY ");
            }
            columnList.add(columnBuilder.toString());
            columnBuilder.delete(0, columnBuilder.length());
        });
        return columnList;
    }

    public static String buildDescTableSql(String schemaName, String tableName) {
        StringBuilder sql = new StringBuilder().append(" SELECT C.COLUMN_NAME AS NAME,C.DATA_TYPE AS TYPE,CAST(D.VALUE AS VARCHAR) AS COMMENT FROM ").append("(SELECT B.OBJECT_ID,A.TABLE_NAME,A.COLUMN_NAME,A.DATA_TYPE,A.ORDINAL_POSITION").append(" FROM INFORMATION_SCHEMA.COLUMNS A LEFT JOIN SYS.TABLES B").append(" ON A.TABLE_NAME = B.NAME").append("  WHERE A.TABLE_NAME = '").append(tableName).append("'  AND A.TABLE_SCHEMA = '").append(schemaName).append("') C  LEFT JOIN SYS.EXTENDED_PROPERTIES D").append(" ON C.OBJECT_ID = D.MAJOR_ID ").append(" AND C.ORDINAL_POSITION = D.MINOR_ID ;");
        LOGGER.info("desc table sql={}", (Object)sql);
        return sql.toString();
    }
}

