/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink.pulsar;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.pojo.node.pulsar.PulsarDataNodeDTO;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.pulsar.PulsarSink;
import org.apache.inlong.manager.pojo.sink.pulsar.PulsarSinkDTO;
import org.apache.inlong.manager.pojo.sink.pulsar.PulsarSinkRequest;
import org.apache.inlong.manager.service.sink.AbstractSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PulsarSinkOperator
extends AbstractSinkOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PulsarSinkOperator.class);
    private static final String TOPIC = "topic";
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private DataNodeEntityMapper dataNodeEntityMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "PULSAR".equals(sinkType);
    }

    @Override
    protected String getSinkType() {
        return "PULSAR";
    }

    @Override
    protected void setTargetEntity(SinkRequest request, StreamSinkEntity targetEntity) {
        if (!this.getSinkType().equals(request.getSinkType())) {
            throw new BusinessException(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT, ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage() + ": " + this.getSinkType());
        }
        PulsarSinkRequest sinkRequest = (PulsarSinkRequest)request;
        try {
            PulsarSinkDTO dto = PulsarSinkDTO.getFromRequest((PulsarSinkRequest)sinkRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED, String.format("serialize extParams of Pulsar SinkDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSink getFromEntity(StreamSinkEntity entity) {
        PulsarSink sink = new PulsarSink();
        if (entity == null) {
            return sink;
        }
        DataNodeEntity dataNodeEntity = this.dataNodeEntityMapper.selectByUniqueKey(entity.getDataNodeName(), "PULSAR");
        PulsarDataNodeDTO pulsarDataNodeDTO = (PulsarDataNodeDTO)JsonUtils.parseObject((String)dataNodeEntity.getExtParams(), PulsarDataNodeDTO.class);
        PulsarSinkDTO dto = PulsarSinkDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)pulsarDataNodeDTO, (Object)sink, (boolean)true);
        List<SinkField> sinkFields = super.getSinkFields(entity.getId());
        sink.setSinkFieldList(sinkFields);
        return sink;
    }

    @Override
    public Map<String, String> parse2IdParams(StreamSinkEntity streamSink, List<String> fields) {
        PulsarSinkDTO pulsarSinkDTO;
        Map<String, String> params = super.parse2IdParams(streamSink, fields);
        try {
            pulsarSinkDTO = (PulsarSinkDTO)this.objectMapper.readValue(streamSink.getExtParams(), PulsarSinkDTO.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("parse pulsar sink dto error", (Throwable)e);
            return params;
        }
        String fullTopicName = this.getFullTopicName(pulsarSinkDTO);
        params.put(TOPIC, fullTopicName);
        return params;
    }

    private String getFullTopicName(PulsarSinkDTO pulsarSinkDTO) {
        return pulsarSinkDTO.getPulsarTenant() + "/" + pulsarSinkDTO.getNamespace() + "/" + pulsarSinkDTO.getTopic();
    }
}

