/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.iceberg;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.iceberg.IcebergSource;
import org.apache.inlong.manager.pojo.source.iceberg.IcebergSourceDTO;
import org.apache.inlong.manager.pojo.source.iceberg.IcebergSourceRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcebergSourceOperator
extends AbstractSourceOperator {
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sourceType) {
        return "ICEBERG".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "ICEBERG";
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        IcebergSourceRequest sourceRequest = (IcebergSourceRequest)request;
        CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
        try {
            IcebergSourceDTO dto = IcebergSourceDTO.getFromRequest((IcebergSourceRequest)sourceRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of Kafka SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        IcebergSource source = new IcebergSource();
        if (entity == null) {
            return source;
        }
        IcebergSourceDTO dto = IcebergSourceDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> sourceFields = super.getSourceFields(entity.getId());
        source.setFieldList(sourceFields);
        return source;
    }
}

