/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageInfo;
import org.apache.inlong.manager.common.pojo.datastorage.BaseStorageListVO;
import org.apache.inlong.manager.common.pojo.datastorage.StoragePageRequest;
import org.apache.inlong.manager.common.pojo.query.ColumnInfoBean;
import org.apache.inlong.manager.common.pojo.query.ConnectionInfo;
import org.apache.inlong.manager.common.pojo.query.DatabaseDetail;
import org.apache.inlong.manager.common.pojo.query.TableQueryBean;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.service.core.DataSourceService;
import org.apache.inlong.manager.service.core.StorageService;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/storage"})
@Api(tags={"Data Storage"})
public class StorageController {
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private StorageService storageService;

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save storage information")
    public Response<Integer> save(@RequestBody BaseStorageInfo storageInfo) {
        return Response.success((Object)this.storageService.save(storageInfo, LoginUserUtil.getLoginUserDetail().getUserName()));
    }

    @RequestMapping(value={"/get/{id}"}, method={RequestMethod.GET})
    @ApiOperation(value="Query storage information")
    @ApiImplicitParams(value={@ApiImplicitParam(name="storageType", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)})
    public Response<BaseStorageInfo> get(@RequestParam String storageType, @PathVariable Integer id) {
        return Response.success((Object)this.storageService.getById(storageType, id));
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ApiOperation(value="Query data storage list based on conditions")
    public Response<PageInfo<? extends BaseStorageListVO>> listByCondition(StoragePageRequest request) {
        return Response.success((Object)this.storageService.listByCondition(request));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Modify data storage information")
    public Response<Boolean> update(@RequestBody BaseStorageInfo storageInfo) {
        return Response.success((Object)this.storageService.update(storageInfo, LoginUserUtil.getLoginUserDetail().getUserName()));
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    @OperationLog(operation=OperationType.DELETE)
    @ApiOperation(value="Delete data storage information")
    @ApiImplicitParams(value={@ApiImplicitParam(name="storageType", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)})
    public Response<Boolean> delete(@RequestParam String storageType, @PathVariable Integer id) {
        boolean result = this.storageService.delete(storageType, id, LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success((Object)result);
    }

    @RequestMapping(value={"/query/testConnection"}, method={RequestMethod.POST})
    @ApiOperation(value="Test the connection")
    public Response<Boolean> testConnection(@RequestBody ConnectionInfo connectionInfo) {
        return Response.success((Object)this.dataSourceService.testConnection(connectionInfo));
    }

    @RequestMapping(value={"/query/createDb"}, method={RequestMethod.POST})
    @ApiOperation(value="Create database if not exists")
    public Response<Object> createDb(@RequestBody TableQueryBean queryBean) throws Exception {
        this.dataSourceService.createDb((Object)queryBean);
        return Response.success();
    }

    @RequestMapping(value={"/query/columns"}, method={RequestMethod.POST})
    @ApiOperation(value="Query table columns")
    public Response<List<ColumnInfoBean>> queryColumns(@RequestBody TableQueryBean queryBean) throws Exception {
        return Response.success((Object)this.dataSourceService.queryColumns((Object)queryBean));
    }

    @RequestMapping(value={"/query/dbDetail"}, method={RequestMethod.POST})
    @ApiOperation(value="Query database detail")
    public Response<DatabaseDetail> queryDbDetail(@RequestBody TableQueryBean queryBean) throws Exception {
        return Response.success((Object)this.dataSourceService.queryDbDetail((Object)queryBean));
    }
}

