/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeConsumeGroupRequest;
import org.apache.inlong.manager.common.pojo.tubemq.AddTubeMqTopicRequest;
import org.apache.inlong.manager.common.pojo.user.UserDetail;
import org.apache.inlong.manager.service.thirdpart.mq.TubeMqOptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/thirdpart"})
@Api(tags={"Third Part System"})
public class ThirdPartController {
    @Autowired
    private TubeMqOptService tubeMqOptService;

    @PostMapping(value={"/createTopic"})
    @ApiOperation(value="Create tube topic")
    public Response<UserDetail> createTopic(@RequestBody AddTubeMqTopicRequest request) {
        try {
            this.tubeMqOptService.createNewTopic(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.success();
    }

    @PostMapping(value={"/createGroup"})
    @ApiOperation(value="Create a tube consumer group")
    public Response<UserDetail> createGroup(@RequestBody AddTubeConsumeGroupRequest request) throws Exception {
        this.tubeMqOptService.createNewConsumerGroup(request);
        return Response.success();
    }
}

