/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyConfig;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyIpRequest;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyIpResponse;
import org.apache.inlong.manager.service.core.DataProxyClusterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi/dataproxy"})
@Api(tags={"DataProxy Config"})
public class DataProxyController {
    @Autowired
    private DataProxyClusterService dataProxyClusterService;

    @PostMapping(value={"/getIpList"})
    @ApiOperation(value="get data proxy ip list")
    public Response<List<DataProxyIpResponse>> getIpList(@RequestBody DataProxyIpRequest request) {
        return Response.success((Object)this.dataProxyClusterService.getIpList(request));
    }

    @GetMapping(value={"/getConfig"})
    @ApiOperation(value="get data proxy config list")
    public Response<List<DataProxyConfig>> getConfig() {
        return Response.success((Object)this.dataProxyClusterService.getConfig());
    }
}

