/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.config;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnMissingBean(value={RestTemplate.class})
@ConfigurationProperties(prefix="common.http-client")
public class RestTemplateConfig {
    private int maxTotal = 5000;
    private int defaultMaxPerRoute = 2000;
    private int validateAfterInactivity = 5000;
    private int connectionTimeout = 3000;
    private int readTimeout = 10000;
    private int connectionRequestTimeout = 3000;

    @Bean
    public PoolingHttpClientConnectionManager httpClientConnectionManager() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
        httpClientConnectionManager.setMaxTotal(this.maxTotal);
        httpClientConnectionManager.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
        httpClientConnectionManager.setValidateAfterInactivity(this.validateAfterInactivity);
        return httpClientConnectionManager;
    }

    @Bean
    public HttpClient httpClient() {
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.httpClientConnectionManager()).setKeepAliveStrategy((ConnectionKeepAliveStrategy)CustomConnectionKeepAliveStrategy.INSTANCE).build();
    }

    @Bean
    public HttpComponentsClientHttpRequestFactory clientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory(this.httpClient());
        factory.setConnectTimeout(this.connectionTimeout);
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectionRequestTimeout(this.connectionRequestTimeout);
        return factory;
    }

    @Bean
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory((ClientHttpRequestFactory)this.clientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        this.setRestTemplateEncode(restTemplate);
        return restTemplate;
    }

    private void setRestTemplateEncode(RestTemplate restTemplate) {
        if (null == restTemplate || ObjectUtils.isEmpty((Object)restTemplate.getMessageConverters())) {
            return;
        }
        List messageConverters = restTemplate.getMessageConverters();
        for (int i = 0; i < messageConverters.size(); ++i) {
            HttpMessageConverter httpMessageConverter = (HttpMessageConverter)messageConverters.get(i);
            if (!httpMessageConverter.getClass().equals(StringHttpMessageConverter.class)) continue;
            messageConverters.set(i, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        }
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public int getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public void setValidateAfterInactivity(int validateAfterInactivity) {
        this.validateAfterInactivity = validateAfterInactivity;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestTemplateConfig)) {
            return false;
        }
        RestTemplateConfig other = (RestTemplateConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxTotal() != other.getMaxTotal()) {
            return false;
        }
        if (this.getDefaultMaxPerRoute() != other.getDefaultMaxPerRoute()) {
            return false;
        }
        if (this.getValidateAfterInactivity() != other.getValidateAfterInactivity()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        return this.getConnectionRequestTimeout() == other.getConnectionRequestTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestTemplateConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxTotal();
        result = result * 59 + this.getDefaultMaxPerRoute();
        result = result * 59 + this.getValidateAfterInactivity();
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getConnectionRequestTimeout();
        return result;
    }

    public String toString() {
        return "RestTemplateConfig(maxTotal=" + this.getMaxTotal() + ", defaultMaxPerRoute=" + this.getDefaultMaxPerRoute() + ", validateAfterInactivity=" + this.getValidateAfterInactivity() + ", connectionTimeout=" + this.getConnectionTimeout() + ", readTimeout=" + this.getReadTimeout() + ", connectionRequestTimeout=" + this.getConnectionRequestTimeout() + ")";
    }

    public static class CustomConnectionKeepAliveStrategy
    implements ConnectionKeepAliveStrategy {
        public static CustomConnectionKeepAliveStrategy INSTANCE = new CustomConnectionKeepAliveStrategy();

        private CustomConnectionKeepAliveStrategy() {
        }

        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            return 30000L;
        }
    }
}

