/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.common.pojo.cluster.DataProxyClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.DataProxyClusterPageRequest;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.service.core.ClusterInfoService;
import org.apache.inlong.manager.service.core.DataProxyClusterService;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cluster"})
@Api(tags={"Cluster Config"})
public class ClusterController {
    @Autowired
    private ClusterInfoService clusterInfoService;
    @Autowired
    private DataProxyClusterService dataProxyClusterService;

    @RequestMapping(value={"/common/list"}, method={RequestMethod.GET})
    @ApiOperation(value="Query the list of general clusters based on conditions")
    public Response<List<ClusterInfo>> list(ClusterRequest request) {
        return Response.success((Object)this.clusterInfoService.list(request));
    }

    @RequestMapping(value={"/dataproxy/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save cluster information of the DataProxy")
    public Response<Integer> saveDataProxy(@RequestBody DataProxyClusterInfo clusterInfo) {
        String currentUser = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.dataProxyClusterService.save(clusterInfo, currentUser));
    }

    @RequestMapping(value={"/dataproxy/get/{id}"}, method={RequestMethod.GET})
    @ApiOperation(value="Query cluster information of the DataProxy")
    @ApiImplicitParam(name="id", value="DataProxy cluster ID", dataTypeClass=Integer.class, required=true)
    public Response<DataProxyClusterInfo> getDataProxy(@PathVariable Integer id) {
        return Response.success((Object)this.dataProxyClusterService.get(id));
    }

    @RequestMapping(value={"/dataproxy/list"}, method={RequestMethod.GET})
    @ApiOperation(value="Query the list of DataProxy clusters based on conditions")
    public Response<PageInfo<DataProxyClusterInfo>> listDataProxyByCondition(DataProxyClusterPageRequest request) {
        request.setCurrentUser(LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success((Object)this.dataProxyClusterService.listByCondition(request));
    }

    @RequestMapping(value={"/DataProxy/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Modify cluster information of the DataProxy")
    public Response<Boolean> updateDataProxy(@RequestBody DataProxyClusterInfo clusterInfo) {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.dataProxyClusterService.update(clusterInfo, username));
    }

    @RequestMapping(value={"/dataproxy/delete/{id}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete cluster information of the dataproxy")
    @OperationLog(operation=OperationType.DELETE)
    @ApiImplicitParam(name="id", value="DataProxy cluster id", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> deleteDataProxy(@PathVariable Integer id) {
        return Response.success((Object)this.dataProxyClusterService.delete(id, LoginUserUtil.getLoginUserDetail().getUserName()));
    }
}

