/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import com.opencsv.bean.ColumnPositionMappingStrategy;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.bean.MappingStrategy;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.BizErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.commonserver.CommonFileServerInfo;
import org.apache.inlong.manager.common.pojo.commonserver.CommonFileServerListVo;
import org.apache.inlong.manager.common.pojo.commonserver.CommonFileServerPageRequest;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.util.SmallTools;
import org.apache.inlong.manager.service.core.CommonFileServerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"commonserver/file"})
@Api(tags={"Common Server - File"})
public class CommonFileServerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonFileServerController.class);
    @Autowired
    CommonFileServerService commonFileServerService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="Create a new file data source")
    public Response<Integer> create(@RequestBody CommonFileServerInfo commonFileServerInfo) throws Exception {
        int id = this.commonFileServerService.create(commonFileServerInfo);
        return Response.success((Object)id);
    }

    @PostMapping(value={"/freeze/{id}"})
    @ApiOperation(value="Freeze file data source")
    public Response<CommonFileServerInfo> freeze(@RequestBody @PathVariable int id) {
        CommonFileServerInfo result = this.commonFileServerService.freeze(id);
        return Response.success((Object)result);
    }

    @PostMapping(value={"/unfreeze/{id}"})
    @ApiOperation(value="Unfreeze file data source")
    public Response<CommonFileServerInfo> unfreeze(@RequestBody @PathVariable int id) {
        CommonFileServerInfo result = this.commonFileServerService.unfreeze(id);
        return Response.success((Object)result);
    }

    @RequestMapping(value={"/deleteById/{id}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete file data source")
    public Response<CommonFileServerInfo> delete(@RequestBody @PathVariable int id) throws Exception {
        this.commonFileServerService.delete(id);
        return Response.success();
    }

    @RequestMapping(value={"/getById/{id}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get file data source")
    public Response<CommonFileServerInfo> get(@RequestBody @PathVariable int id) throws Exception {
        CommonFileServerInfo result = this.commonFileServerService.get(id);
        return Response.success((Object)result);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="Modify file data source")
    public Response<CommonFileServerInfo> update(@RequestBody CommonFileServerInfo commonFileServerInfo) throws Exception {
        CommonFileServerInfo result = this.commonFileServerService.update(commonFileServerInfo);
        return Response.success((Object)result);
    }

    @RequestMapping(value={"/getByUser/{username}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get data source by user")
    @ApiImplicitParam(name="username", dataTypeClass=String.class, required=true)
    public Response<List<CommonFileServerInfo>> getByUser(@PathVariable String username) {
        List result = this.commonFileServerService.getByUser(username);
        return Response.success((Object)result);
    }

    @PostMapping(value={"/addVisiblePerson/{id}"})
    @ApiOperation(value="Add visible Person")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", dataTypeClass=Integer.class), @ApiImplicitParam(name="visiblePerson", value="Visible person list, separated by commas", dataTypeClass=String.class)})
    public Response<CommonFileServerInfo> addVisiblePerson(@PathVariable(value="id") Integer id, @RequestParam(value="visiblePerson") String visiblePerson) {
        CommonFileServerInfo result = this.commonFileServerService.addVisiblePerson(id, visiblePerson);
        return Response.success((Object)result);
    }

    @PostMapping(value={"/deleteVisiblePerson/{id}"})
    @ApiOperation(value="Delete visible person")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", dataTypeClass=Integer.class), @ApiImplicitParam(name="visiblePerson", value="Visible person list, separated by commas", dataTypeClass=String.class)})
    public Response<CommonFileServerInfo> deleteVisiblePerson(@PathVariable(value="id") Integer id, @RequestParam(value="visiblePerson") String visiblePerson) {
        CommonFileServerInfo result = this.commonFileServerService.deleteVisiblePerson(id, visiblePerson);
        return Response.success((Object)result);
    }

    @PostMapping(value={"/addVisibleGroup/{id}"})
    @ApiOperation(value="Add visible group")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", dataTypeClass=Integer.class), @ApiImplicitParam(name="visibleGroup", value="Visible group list, separated by commas", dataTypeClass=String.class)})
    public Response<CommonFileServerInfo> addVisibleGroup(@PathVariable(value="id") Integer id, @RequestParam(value="visibleGroup") String visibleGroup) {
        CommonFileServerInfo result = this.commonFileServerService.addVisibleGroup(id, visibleGroup);
        return Response.success((Object)result);
    }

    @PostMapping(value={"/deleteVisibleGroup/{id}"})
    @ApiOperation(value="Delete visible group")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", dataTypeClass=Integer.class), @ApiImplicitParam(name="visibleGroup", value="Visible group list, separated by commas", dataTypeClass=String.class)})
    public Response<CommonFileServerInfo> deleteVisibleGroup(@PathVariable(value="id") Integer id, @RequestParam(value="visibleGroup") String visibleGroup) {
        CommonFileServerInfo result = this.commonFileServerService.deleteVisibleGroup(id, visibleGroup);
        return Response.success((Object)result);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ApiOperation(value="Query data source list based on conditions")
    public Response<PageInfo<CommonFileServerListVo>> listByCondition(CommonFileServerPageRequest request) throws Exception {
        return Response.success((Object)this.commonFileServerService.listByCondition(request));
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    @ApiOperation(value="Download import module")
    public String download(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = "common_file_server_template.csv";
        String realPath = new File("").getAbsolutePath();
        File file = new File(realPath, fileName);
        if (file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                response.setContentType("application/force-download");
                fileName = URLEncoder.encode(fileName, "UTF-8");
                response.addHeader("Content-Disposition", "attachment;fileName=" + fileName);
                byte[] buffer = new byte[1024];
                ServletOutputStream os = response.getOutputStream();
                int i = bis.read(buffer);
                while (i != -1) {
                    os.write(buffer, 0, i);
                    i = bis.read(buffer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    @ApiOperation(value="Batch Import - upload config")
    public String upload(@RequestParam(value="file") MultipartFile file) throws Exception {
        Preconditions.checkFalse((boolean)file.isEmpty(), (String)"File cannot be empty");
        String fileName = file.getOriginalFilename();
        LOGGER.info("The name of the upload file is\uff1a" + fileName);
        String filePath = ClassUtils.getDefaultClassLoader().getResource("").getPath();
        File fileDir = new File(filePath, "common_server");
        if (!fileDir.exists()) {
            fileDir.mkdirs();
        }
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        String time = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        fileName = username + "_" + time + "_" + fileName;
        Path path = Paths.get(fileDir.getAbsolutePath(), fileName);
        if (Files.exists(path, new LinkOption[0])) {
            throw new BusinessException(BizErrorCodeEnum.COMMON_FILE_UPLOAD_FAIL, "The file [" + fileName + "] already exists, please try again later");
        }
        int count = 0;
        try {
            file.transferTo(path.toFile());
            try (BufferedReader br = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                Iterator iterator;
                ColumnPositionMappingStrategy strategy = new ColumnPositionMappingStrategy();
                strategy.setType(CommonFileServerInfo.class);
                String[] fields = new String[]{"ip", "port", "type", "isInnerIp", "issueType", "username", "password", "visiblePerson", "visibleGroup"};
                strategy.setColumnMapping(fields);
                CsvToBean csvToBean = new CsvToBeanBuilder((Reader)br).withType(CommonFileServerInfo.class).withMappingStrategy((MappingStrategy)strategy).withIgnoreLeadingWhiteSpace(true).withSeparator(',').build();
                List fileServerInfos = csvToBean.parse();
                if (fileServerInfos.size() > 10000) {
                    String string = "Failed, the number of data exceeds the upper limit [10000]";
                    return string;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("csv format\uff0cThe fields are  ip, port, type, isInnerIp, issueType, username, password, visiblePerson, visibleGroup\n");
                sb.append("Incorrect data check\n");
                int i = 1;
                boolean passed = true;
                for (CommonFileServerInfo entry : fileServerInfos) {
                    if (!SmallTools.ipCheck((String)entry.getIp())) {
                        sb.append(i + " column, ip=[" + entry.getIp() + "]Incorrect check\n");
                        passed = false;
                    }
                    if (!SmallTools.portCheck((int)entry.getPort())) {
                        sb.append(i + " column, port=[" + entry.getPort() + "]Incorrect check\n");
                        passed = false;
                    }
                    ++i;
                }
                if (!passed) {
                    iterator = sb.toString();
                    return iterator;
                }
                iterator = fileServerInfos.iterator();
                while (iterator.hasNext()) {
                    CommonFileServerInfo entry;
                    entry = (CommonFileServerInfo)iterator.next();
                    this.commonFileServerService.create(entry);
                    ++count;
                }
                return "success, a total of 2 " + count + "are written.";
            }
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
            return "failure, a total of 2 " + count + "are written.";
        }
    }
}

