/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionInfo;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionListVo;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionQuery;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionSummary;
import org.apache.inlong.manager.common.pojo.dataconsumption.ConsumptionUpdateInfo;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.service.core.ConsumptionService;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.apache.inlong.manager.service.workflow.WorkflowResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/consumption"})
@Api(tags={"Data Consumption"})
public class ConsumptionController {
    private ConsumptionService consumptionService;

    @Autowired
    public ConsumptionController(ConsumptionService consumptionService) {
        this.consumptionService = consumptionService;
    }

    @GetMapping(value={"summary"})
    @ApiOperation(value="Get data consumption summary")
    public Response<ConsumptionSummary> getSummary(ConsumptionQuery query) {
        query.setUserName(LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success((Object)this.consumptionService.getSummary(query));
    }

    @GetMapping(value={"list"})
    @ApiOperation(value="List data consumptions")
    public Response<PageInfo<ConsumptionListVo>> list(ConsumptionQuery query) {
        query.setUserName(LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success((Object)this.consumptionService.list(query));
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="Get consumption details")
    public Response<ConsumptionInfo> getDetail(@ApiParam(value="Consumption ID", required=true) @PathVariable(name="id") Integer id) {
        return Response.success((Object)this.consumptionService.getInfo(id));
    }

    @DeleteMapping(value={"delete/{id}"})
    @OperationLog(operation=OperationType.DELETE)
    @ApiOperation(value="Delete data consumption")
    public Response<Object> delete(@ApiParam(value="Consumption ID", required=true) @PathVariable(name="id") Integer id) {
        this.consumptionService.delete(id, LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success();
    }

    @PostMapping(value={"save"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Save data consumption", notes="Full coverage")
    public Response<Integer> saveConsumptionInfo(@Validated @RequestBody ConsumptionInfo consumptionInfo) {
        String currentUser = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.consumptionService.save(consumptionInfo, currentUser));
    }

    @PostMapping(value={"update/{id}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Update data consumption")
    public Response<Integer> updateConsumptionInfo(@ApiParam(value="Consumption ID", required=true) @PathVariable(name="id") Integer id, @Validated @RequestBody ConsumptionUpdateInfo consumptionUpdateInfo) {
        consumptionUpdateInfo.setId(id);
        String currentUser = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.consumptionService.update(consumptionUpdateInfo, currentUser));
    }

    @PostMapping(value={"startProcess/{id}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Start approval process")
    @ApiImplicitParam(name="id", value="Consumption ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> startProcess(@PathVariable(name="id") Integer id) {
        String username = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.consumptionService.startProcess(id, username));
    }
}

