/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.pojo.business.DataSchemaInfo;
import org.apache.inlong.manager.common.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.service.core.ClusterInfoService;
import org.apache.inlong.manager.service.core.DataSchemaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basic"})
@Api(tags={"Basic Config"})
public class BasicInfoController {
    @Autowired
    private ClusterInfoService clusterInfoService;
    @Autowired
    private DataSchemaService schemaService;

    @RequestMapping(value={"/cluster/list"}, method={RequestMethod.GET})
    @ApiOperation(value="Query the cluster list based on conditions")
    public Response<List<ClusterInfo>> list(ClusterRequest request) {
        return Response.success((Object)this.clusterInfoService.list(request));
    }

    @ApiOperation(value="Query data format list")
    @RequestMapping(value={"/schema/listAll"}, method={RequestMethod.GET})
    public Response<List<DataSchemaInfo>> dataSchemaList() {
        return Response.success((Object)this.schemaService.listAllDataSchema());
    }
}

