/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.pojo.user.PasswordChangeRequest;
import org.apache.inlong.manager.common.pojo.user.UserDetail;
import org.apache.inlong.manager.common.pojo.user.UserDetailListVO;
import org.apache.inlong.manager.common.pojo.user.UserDetailPageRequest;
import org.apache.inlong.manager.common.pojo.user.UserInfo;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.service.core.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
@Api(tags={"User - Auth"})
public class UserController {
    @Autowired
    UserService userService;

    @PostMapping(value={"/loginUser"})
    @ApiOperation(value="Get the logged-in user")
    public Response<UserDetail> currentUser() {
        return Response.success((Object)LoginUserUtil.getLoginUserDetail());
    }

    @PostMapping(value={"/register"})
    @ApiOperation(value="Register user")
    public Response<Boolean> register(@RequestBody UserInfo userInfo) {
        userInfo.checkValid();
        return Response.success((Object)this.userService.create(userInfo));
    }

    @GetMapping(value={"/get/{id}"})
    @ApiOperation(value="Get user info")
    public Response<UserInfo> getById(@PathVariable Integer id) {
        return Response.success((Object)this.userService.getById(id));
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="Update user info")
    public Response<Integer> update(@RequestBody UserInfo userInfo) {
        String currentUser = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.userService.update(userInfo, currentUser));
    }

    @PostMapping(value={"/updatePassword"})
    @ApiOperation(value="Update user password")
    public Response<Integer> updatePassword(@RequestBody PasswordChangeRequest request) {
        return Response.success((Object)this.userService.updatePassword(request));
    }

    @GetMapping(value={"/listAllUsers"})
    @ApiOperation(value="List all users")
    public Response<PageInfo<UserDetailListVO>> list(UserDetailPageRequest request) {
        return Response.success((Object)this.userService.list(request));
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="Delete user by id")
    public Response<Boolean> delete(@RequestParam(value="id") Integer id) {
        String currentUser = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.userService.delete(id, currentUser));
    }
}

