/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApprover;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApproverQuery;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/approver"})
@Api(tags={"Workflow Approver"})
public class WorkflowApproverController {
    private static final Logger log = LoggerFactory.getLogger(WorkflowApproverController.class);
    @Autowired
    private WorkflowApproverService workflowApproverService;

    @GetMapping(value={"list"})
    public Response<List<WorkflowApprover>> list(WorkflowApproverQuery query) {
        return Response.success((Object)this.workflowApproverService.list(query));
    }

    @PostMapping(value={"add"})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Add approver configuration")
    public Response<Object> add(@RequestBody WorkflowApprover config) {
        this.workflowApproverService.add(config, LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success();
    }

    @PostMapping(value={"update/{id}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Update approver configuration")
    public Response<Object> update(@RequestBody WorkflowApprover config) {
        this.workflowApproverService.update(config, LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success();
    }

    @DeleteMapping(value={"delete/{id}"})
    @OperationLog(operation=OperationType.DELETE)
    @ApiOperation(value="Delete approver configuration")
    @ApiParam(value="Configuration item ID", required=true)
    public Response<Object> delete(@PathVariable Integer id) {
        this.workflowApproverService.delete(id, LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success();
    }
}

