/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.util.LoginUserUtil;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.apache.inlong.manager.service.workflow.WorkflowOperation;
import org.apache.inlong.manager.service.workflow.WorkflowResult;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.service.workflow.WorkflowTaskExecuteLog;
import org.apache.inlong.manager.service.workflow.WorkflowTaskExecuteLogQuery;
import org.apache.inlong.manager.service.workflow.WorkflowTaskOperation;
import org.apache.inlong.manager.workflow.model.definition.ProcessForm;
import org.apache.inlong.manager.workflow.model.definition.TaskForm;
import org.apache.inlong.manager.workflow.model.view.ProcessDetail;
import org.apache.inlong.manager.workflow.model.view.ProcessListView;
import org.apache.inlong.manager.workflow.model.view.ProcessQuery;
import org.apache.inlong.manager.workflow.model.view.ProcessSummaryQuery;
import org.apache.inlong.manager.workflow.model.view.ProcessSummaryView;
import org.apache.inlong.manager.workflow.model.view.TaskListView;
import org.apache.inlong.manager.workflow.model.view.TaskQuery;
import org.apache.inlong.manager.workflow.model.view.TaskSummaryQuery;
import org.apache.inlong.manager.workflow.model.view.TaskSummaryView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow"})
@Api(tags={"Workflow Config"})
public class WorkflowController {
    private static final Logger log = LoggerFactory.getLogger(WorkflowController.class);
    @Autowired
    private WorkflowService workflowService;

    @PostMapping(value={"start"})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Initiation process")
    public Response<WorkflowResult> start(@RequestBody WorkflowOperation operation) {
        String applicant = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.start(operation.getName(), applicant, (ProcessForm)operation.getForm()));
    }

    @PostMapping(value={"cancel/{processId}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Cancellation process")
    @ApiImplicitParam(name="processId", value="Process ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> cancel(@PathVariable Integer processId, @RequestBody WorkflowOperation operation) {
        String operator = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.cancel(processId, operator, operation.getRemark()));
    }

    @PostMapping(value={"approve/{taskId}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Approval and consent")
    @ApiImplicitParam(name="taskId", value="Task ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> approve(@PathVariable Integer taskId, @RequestBody WorkflowTaskOperation operation) {
        String operator = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.approve(taskId, operation.getRemark(), (TaskForm)operation.getForm(), operator));
    }

    @PostMapping(value={"reject/{taskId}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Approval rejected")
    @ApiImplicitParam(name="taskId", value="Task ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> reject(@PathVariable Integer taskId, @RequestBody WorkflowTaskOperation operation) {
        String operator = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.reject(taskId, operation.getRemark(), operator));
    }

    @PostMapping(value={"transfer/{taskId}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Turn to do", notes="Change approver")
    @ApiImplicitParam(name="taskId", value="Task ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> transfer(@PathVariable Integer taskId, @RequestBody WorkflowTaskOperation operation) {
        String operator = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.transfer(taskId, operation.getRemark(), operation.getTransferTo(), operator));
    }

    @PostMapping(value={"complete/{taskId}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Finish")
    @ApiImplicitParam(name="taskId", value="Task ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> complete(@PathVariable Integer taskId, @RequestBody WorkflowTaskOperation operation) {
        String operator = LoginUserUtil.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.complete(taskId, operation.getRemark(), operator));
    }

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="Get application details")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="Process ticket ID", dataTypeClass=Integer.class, required=true), @ApiImplicitParam(name="taskInstId", value="Task ID", dataTypeClass=Integer.class)})
    public Response<ProcessDetail> detail(@PathVariable(name="id") Integer id, @RequestParam(required=false) Integer taskInstId) {
        return Response.success((Object)this.workflowService.detail(id, taskInstId));
    }

    @GetMapping(value={"/listProcess"})
    @ApiOperation(value="Get my list of process sheets")
    public Response<PageInfo<ProcessListView>> listProcess(ProcessQuery query) {
        query.setApplicant(LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success((Object)this.workflowService.listProcess(query));
    }

    @GetMapping(value={"/listTask"})
    @ApiOperation(value="Get my task list")
    public Response<PageInfo<TaskListView>> listTask(TaskQuery query) {
        query.setApprover(LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success((Object)this.workflowService.listTask(query));
    }

    @GetMapping(value={"/processSummary"})
    @ApiOperation(value="Obtain application form statistics")
    public Response<ProcessSummaryView> processSummary(ProcessSummaryQuery query) {
        query.setApplicant(LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success((Object)this.workflowService.processSummary(query));
    }

    @GetMapping(value={"/taskSummary"})
    @ApiOperation(value="Get approval task statistics")
    public Response<TaskSummaryView> taskSummary(TaskSummaryQuery query) {
        query.setApprover(LoginUserUtil.getLoginUserDetail().getUserName());
        return Response.success((Object)this.workflowService.taskSummary(query));
    }

    @GetMapping(value={"/listTaskExecuteLogs"})
    @ApiOperation(value="Get task execution log")
    public Response<PageInfo<WorkflowTaskExecuteLog>> listTaskExecuteLogs(WorkflowTaskExecuteLogQuery query) {
        return Response.success((Object)this.workflowService.listTaskExecuteLogs(query));
    }
}

