/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.pojo.dbcollector.DBCollectorReportTaskRequest;
import org.apache.inlong.manager.common.pojo.dbcollector.DBCollectorTaskInfo;
import org.apache.inlong.manager.common.pojo.dbcollector.DBCollectorTaskRequest;
import org.apache.inlong.manager.service.core.DBCollectorTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi/dbCollector"})
@Api(tags={"DBCollector Config"})
public class DBCollectorController {
    @Autowired
    private DBCollectorTaskService taskService;

    @PostMapping(value={"/getTask"})
    @ApiOperation(value="fetch db collector task")
    public Response<DBCollectorTaskInfo> getTask(@RequestBody DBCollectorTaskRequest req) {
        return Response.success((Object)this.taskService.getTask(req));
    }

    @PostMapping(value={"/reportTask"})
    @ApiOperation(value="report task state")
    public Response<Integer> reportTask(@RequestBody DBCollectorReportTaskRequest req) {
        return Response.success((Object)this.taskService.reportTask(req));
    }
}

