/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth;

import javax.annotation.Resource;
import org.apache.inlong.manager.common.auth.InlongShiro;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    @Resource
    private InlongShiro inLongShiro;

    @Bean
    public AuthorizingRealm shiroRealm(HashedCredentialsMatcher matcher) {
        AuthorizingRealm authorizingRealm = this.inLongShiro.getShiroRealm();
        authorizingRealm.setCredentialsMatcher((CredentialsMatcher)matcher);
        return authorizingRealm;
    }

    @Bean
    public WebSecurityManager securityManager(@Qualifier(value="hashedCredentialsMatcher") HashedCredentialsMatcher matcher) {
        DefaultWebSecurityManager securityManager = (DefaultWebSecurityManager)this.inLongShiro.getWebSecurityManager();
        securityManager.setRealm((Realm)this.shiroRealm(matcher));
        return securityManager;
    }

    @Bean
    public DefaultWebSessionManager sessionManager() {
        DefaultWebSessionManager sessionManager = (DefaultWebSessionManager)this.inLongShiro.getWebSessionManager();
        sessionManager.setGlobalSessionTimeout(3600000L);
        return sessionManager;
    }

    @Bean(name={"hashedCredentialsMatcher"})
    public HashedCredentialsMatcher hashedCredentialsMatcher() {
        HashedCredentialsMatcher hashedCredentialsMatcher = (HashedCredentialsMatcher)this.inLongShiro.getCredentialsMatcher();
        return hashedCredentialsMatcher;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = this.inLongShiro.getShiroFilter(securityManager);
        return shiroFilterFactoryBean;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor() {
        return this.inLongShiro.getAuthorizationAttributeSourceAdvisor((SecurityManager)this.securityManager(this.hashedCredentialsMatcher()));
    }
}

