/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import org.apache.inlong.manager.common.pojo.user.UserDetail;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.UserEntity;
import org.apache.inlong.manager.service.core.UserService;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class WebAuthorizingRealm
extends AuthorizingRealm {
    private UserService userService;

    public WebAuthorizingRealm(UserService userService) {
        this.userService = userService;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)authenticationToken;
        String username = upToken.getUsername();
        UserEntity userEntity = this.userService.getByName(username);
        Preconditions.checkNotNull((Object)userEntity, (String)"User doesn't exist");
        Preconditions.checkTrue((boolean)userEntity.getDueDate().after(new Date()), (String)"user has expired");
        UserDetail userDetail = new UserDetail();
        userDetail.setUserName(username);
        userDetail.setRoles((Set)Sets.newHashSet((Object[])new String[]{userEntity.getAccountType().toString()}));
        return new SimpleAuthenticationInfo((Object)userDetail, (Object)userEntity.getPassword(), this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }
}

