/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.config;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.pojo.user.UserDetail;
import org.apache.inlong.manager.common.util.LoginUserUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    public Response<String> handleConstraintViolationException(HttpServletRequest request, ConstraintViolationException e) {
        Set violations = e.getConstraintViolations();
        StringBuilder stringBuilder = new StringBuilder(64);
        for (ConstraintViolation violation : violations) {
            stringBuilder.append(violation.getMessage()).append(".");
        }
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        log.error("Failed to handle request on path:" + request.getRequestURI() + (userDetail != null ? ", user:" + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)stringBuilder.toString());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public Response<String> handleMethodArgumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        log.error("Failed to handle request on path:" + request.getRequestURI() + (userDetail != null ? ", user:" + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)((ObjectError)e.getBindingResult().getAllErrors().get(0)).getDefaultMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={IllegalArgumentException.class})
    public Response<String> handleIllegalArgumentException(HttpServletRequest request, IllegalArgumentException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        log.error("Failed to handle request on path:" + request.getRequestURI() + (userDetail != null ? ", user:" + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={BindException.class})
    public Response<String> handleBindExceptionHandler(HttpServletRequest request, BindException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        log.error("Failed to handle request on path:" + request.getRequestURI() + (userDetail != null ? ", user:" + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)((ObjectError)e.getBindingResult().getAllErrors().get(0)).getDefaultMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={HttpMessageConversionException.class})
    public Response<String> handleHttpMessageConversionExceptionHandler(HttpServletRequest request, HttpMessageConversionException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        log.error("Failed to handle request on path:" + request.getRequestURI() + (userDetail != null ? ", user:" + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)"http message convert exception! pls check params");
    }

    @ResponseBody
    @ExceptionHandler(value={WorkflowException.class})
    public Response<String> handleWorkflowException(HttpServletRequest request, WorkflowException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        log.error("Failed to handle request on path:" + request.getRequestURI() + (userDetail != null ? ", user:" + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={BusinessException.class})
    public Response<String> handleBusinessExceptionHandler(HttpServletRequest request, BusinessException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        log.error("Failed to handle request on path:" + request.getRequestURI() + (userDetail != null ? ", user:" + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={AuthenticationException.class})
    public Response<String> handleAuthenticationException(HttpServletRequest request, AuthenticationException e) {
        log.error("Failed to handle request on path:" + request.getRequestURI(), (Throwable)e);
        return Response.fail((String)"username or password is incorrect, or the account has expired");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Response<String> handle(HttpServletRequest request, Exception e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        log.error("Failed to handle request on path:" + request.getRequestURI() + (userDetail != null ? ", user:" + userDetail.getUserName() : ""), (Throwable)e);
        return Response.fail((String)"There was an error in the service...Please try again later! If there are still problems, please contact the administrator");
    }
}

