/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.group.InlongGroupCountResponse;
import org.apache.inlong.manager.common.pojo.group.InlongGroupListResponse;
import org.apache.inlong.manager.common.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.common.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.common.pojo.group.InlongGroupResponse;
import org.apache.inlong.manager.common.pojo.group.InlongGroupTopicResponse;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.common.util.LoginUserUtils;
import org.apache.inlong.manager.service.core.InlongGroupService;
import org.apache.inlong.manager.service.core.impl.InlongGroupProcessOperation;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/group"})
@Api(tags={"Inlong-Group-API"})
public class InlongGroupController {
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongGroupProcessOperation groupProcessOperation;

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save inlong group info")
    public Response<String> save(@RequestBody InlongGroupRequest groupInfo) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.groupService.save(groupInfo, operator));
    }

    @RequestMapping(value={"/get/{groupId}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get inlong group info")
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class, required=true)
    public Response<InlongGroupResponse> get(@PathVariable String groupId) {
        return Response.success((Object)this.groupService.get(groupId).genResponse());
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ApiOperation(value="Get inlong group list by paginating")
    public Response<PageInfo<InlongGroupListResponse>> listByCondition(@RequestBody InlongGroupPageRequest request) {
        request.setCurrentUser(LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)this.groupService.listByCondition(request));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Update inlong group info")
    public Response<String> update(@RequestBody InlongGroupRequest groupInfo) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.groupService.update(groupInfo, operator));
    }

    @RequestMapping(value={"/exist/{groupId}"}, method={RequestMethod.GET})
    @ApiOperation(value="Is exists of the inlong group id")
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class, required=true)
    public Response<Boolean> exist(@PathVariable String groupId) {
        return Response.success((Object)this.groupService.exist(groupId));
    }

    @RequestMapping(value={"/countByStatus"}, method={RequestMethod.GET})
    @ApiOperation(value="Count inlong group status for current user")
    public Response<InlongGroupCountResponse> countGroupByUser() {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.groupService.countGroupByUser(operator));
    }

    @RequestMapping(value={"startProcess/{groupId}"}, method={RequestMethod.POST})
    @ApiOperation(value="Start inlong approval process")
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class)
    public Response<WorkflowResult> startProcess(@PathVariable String groupId) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.groupProcessOperation.startProcess(groupId, operator));
    }

    @RequestMapping(value={"suspendProcess/{groupId}"}, method={RequestMethod.POST})
    @ApiOperation(value="Suspend inlong group process")
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class)
    public Response<WorkflowResult> suspendProcess(@PathVariable String groupId) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.groupProcessOperation.suspendProcess(groupId, operator));
    }

    @RequestMapping(value={"restartProcess/{groupId}"}, method={RequestMethod.POST})
    @ApiOperation(value="Restart inlong group process")
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class)
    public Response<WorkflowResult> restartProcess(@PathVariable String groupId) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.groupProcessOperation.restartProcess(groupId, operator));
    }

    @RequestMapping(value={"/delete/{groupId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete inlong group info")
    @OperationLog(operation=OperationType.DELETE)
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class, required=true)
    public Response<Boolean> delete(@PathVariable String groupId) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.groupProcessOperation.deleteProcess(groupId, operator));
    }

    @RequestMapping(value={"suspendProcessAsync/{groupId}"}, method={RequestMethod.POST})
    @ApiOperation(value="Suspend inlong group process")
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class)
    public Response<String> suspendProcessAsync(@PathVariable String groupId) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.groupProcessOperation.suspendProcessAsync(groupId, operator));
    }

    @RequestMapping(value={"restartProcessAsync/{groupId}"}, method={RequestMethod.POST})
    @ApiOperation(value="Restart inlong group process")
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class)
    public Response<String> restartProcessAsync(@PathVariable String groupId) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.groupProcessOperation.restartProcessAsync(groupId, operator));
    }

    @RequestMapping(value={"/deleteAsync/{groupId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete inlong group info")
    @OperationLog(operation=OperationType.DELETE)
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class, required=true)
    public Response<String> deleteAsync(@PathVariable String groupId) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.groupProcessOperation.deleteProcessAsync(groupId, operator));
    }

    @RequestMapping(value={"getTopic/{groupId}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get topic info")
    public Response<InlongGroupTopicResponse> getTopic(@PathVariable String groupId) {
        return Response.success((Object)this.groupService.getTopic(groupId));
    }
}

