/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.stream.FullStreamRequest;
import org.apache.inlong.manager.common.pojo.stream.FullStreamResponse;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamListResponse;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamPageRequest;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamRequest;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamResponse;
import org.apache.inlong.manager.common.pojo.stream.StreamBriefResponse;
import org.apache.inlong.manager.common.util.LoginUserUtils;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stream"})
@Api(tags={"Inlong-Stream-API"})
public class InlongStreamController {
    @Autowired
    private InlongStreamService streamService;

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save inlong stream info")
    public Response<Integer> save(@RequestBody InlongStreamRequest request) {
        int result = this.streamService.save(request, LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)result);
    }

    @RequestMapping(value={"/saveAll"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save inlong stream info page")
    public Response<Boolean> saveAll(@RequestBody FullStreamRequest pageInfo) {
        return Response.success((Object)this.streamService.saveAll(pageInfo, LoginUserUtils.getLoginUserDetail().getUserName()));
    }

    @RequestMapping(value={"/batchSaveAll"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save inlong stream page info in batch")
    public Response<Boolean> batchSaveAll(@RequestBody List<FullStreamRequest> infoList) {
        boolean result = this.streamService.batchSaveAll(infoList, LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)result);
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    @ApiOperation(value="Get inlong stream info")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="streamId", dataTypeClass=String.class, required=true)})
    public Response<InlongStreamResponse> get(@RequestParam String groupId, @RequestParam String streamId) {
        return Response.success((Object)this.streamService.get(groupId, streamId).genResponse());
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    @ApiOperation(value="Get inlong stream by paginating")
    public Response<PageInfo<InlongStreamListResponse>> listByCondition(@RequestBody InlongStreamPageRequest request) {
        request.setCurrentUser(LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)this.streamService.listByCondition(request));
    }

    @RequestMapping(value={"/listAll"}, method={RequestMethod.POST})
    @ApiOperation(value="Get all inlong stream info by paginating")
    public Response<PageInfo<FullStreamResponse>> listAllWithGroupId(@RequestBody InlongStreamPageRequest request) {
        request.setCurrentUser(LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)this.streamService.listAllWithGroupId(request));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Update inlong stream info")
    public Response<Boolean> update(@RequestBody InlongStreamRequest request) {
        String username = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.streamService.update(request, username));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    @OperationLog(operation=OperationType.DELETE)
    @ApiOperation(value="Delete inlong stream info")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="streamId", dataTypeClass=String.class, required=true)})
    public Response<Boolean> delete(@RequestParam String groupId, @RequestParam String streamId) {
        String username = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.streamService.delete(groupId, streamId, username));
    }

    @RequestMapping(value={"/getSummaryList/{groupId}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get inlong stream summary list")
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class, required=true)
    public Response<List<StreamBriefResponse>> getSummaryList(@PathVariable String groupId) {
        return Response.success((Object)this.streamService.getBriefList(groupId));
    }
}

