/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.workflow.ProcessCountQuery;
import org.apache.inlong.manager.common.pojo.workflow.ProcessCountResponse;
import org.apache.inlong.manager.common.pojo.workflow.ProcessDetailResponse;
import org.apache.inlong.manager.common.pojo.workflow.ProcessQuery;
import org.apache.inlong.manager.common.pojo.workflow.ProcessResponse;
import org.apache.inlong.manager.common.pojo.workflow.TaskCountQuery;
import org.apache.inlong.manager.common.pojo.workflow.TaskCountResponse;
import org.apache.inlong.manager.common.pojo.workflow.TaskExecuteLogQuery;
import org.apache.inlong.manager.common.pojo.workflow.TaskQuery;
import org.apache.inlong.manager.common.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowTaskRequest;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.TaskForm;
import org.apache.inlong.manager.common.util.LoginUserUtils;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.apache.inlong.manager.service.workflow.WorkflowExecuteLog;
import org.apache.inlong.manager.service.workflow.WorkflowOperation;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow"})
@Api(tags={"Workflow Config"})
public class WorkflowController {
    private static final Logger log = LoggerFactory.getLogger(WorkflowController.class);
    @Autowired
    private WorkflowService workflowService;

    @PostMapping(value={"/start"})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Initiation process")
    public Response<WorkflowResult> start(@RequestBody WorkflowOperation operation) {
        String applicant = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.start(operation.getName(), applicant, (ProcessForm)operation.getForm()));
    }

    @PostMapping(value={"/cancel/{id}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Cancellation process")
    @ApiImplicitParam(name="id", value="WorkflowProcess ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> cancel(@PathVariable Integer id, @RequestBody WorkflowOperation operation) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.cancel(id, operator, operation.getRemark()));
    }

    @PostMapping(value={"/approve/{id}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Approval and consent")
    @ApiImplicitParam(name="id", value="WorkflowTask ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> approve(@PathVariable Integer id, @RequestBody WorkflowTaskRequest operation) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.approve(id, operation.getRemark(), (TaskForm)operation.getForm(), operator));
    }

    @PostMapping(value={"/reject/{id}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Approval rejected")
    @ApiImplicitParam(name="id", value="WorkflowTask ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> reject(@PathVariable Integer id, @RequestBody WorkflowTaskRequest operation) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.reject(id, operation.getRemark(), operator));
    }

    @PostMapping(value={"/transfer/{id}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Turn to do", notes="Change approver")
    @ApiImplicitParam(name="id", value="WorkflowTask ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> transfer(@PathVariable Integer id, @RequestBody WorkflowTaskRequest operation) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.transfer(id, operation.getRemark(), operation.getTransferTo(), operator));
    }

    @PostMapping(value={"/complete/{id}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Finish task by id")
    @ApiImplicitParam(name="id", value="WorkflowTask ID", dataTypeClass=Integer.class, required=true)
    public Response<WorkflowResult> complete(@PathVariable Integer id, @RequestBody WorkflowTaskRequest request) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.complete(id, request.getRemark(), operator));
    }

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="Get process detail")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="Process ID", dataTypeClass=Integer.class, required=true), @ApiImplicitParam(name="taskId", value="Task ID", dataTypeClass=Integer.class)})
    public Response<ProcessDetailResponse> detail(@PathVariable(name="id") Integer id, @RequestParam(required=false) Integer taskId) {
        String operator = LoginUserUtils.getLoginUserDetail().getUserName();
        return Response.success((Object)this.workflowService.detail(id, taskId, operator));
    }

    @GetMapping(value={"/listProcess"})
    @ApiOperation(value="List my processes")
    public Response<PageInfo<ProcessResponse>> listProcess(ProcessQuery query) {
        query.setApplicant(LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)this.workflowService.listProcess(query));
    }

    @GetMapping(value={"/listTask"})
    @ApiOperation(value="List my tasks")
    public Response<PageInfo<TaskResponse>> listTask(TaskQuery query) {
        query.setApprover(LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)this.workflowService.listTask(query));
    }

    @GetMapping(value={"/processSummary"})
    @ApiOperation(value="Get process statistics")
    public Response<ProcessCountResponse> processSummary(ProcessCountQuery query) {
        query.setApplicant(LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)this.workflowService.countProcess(query));
    }

    @GetMapping(value={"/taskSummary"})
    @ApiOperation(value="Get task statistics")
    public Response<TaskCountResponse> taskSummary(TaskCountQuery query) {
        query.setApprover(LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)this.workflowService.countTask(query));
    }

    @GetMapping(value={"/listTaskExecuteLogs"})
    @ApiOperation(value="Get task execution log")
    public Response<PageInfo<WorkflowExecuteLog>> listTaskExecuteLogs(TaskExecuteLogQuery query) {
        return Response.success((Object)this.workflowService.listTaskExecuteLogs(query));
    }
}

