/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfig;
import org.apache.inlong.common.pojo.dataproxy.ThirdPartyClusterDTO;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyResponse;
import org.apache.inlong.manager.service.core.DataProxyClusterService;
import org.apache.inlong.manager.service.core.ThirdPartyClusterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi/dataproxy"})
@Api(tags={"DataProxy-Config"})
public class DataProxyController {
    @Autowired
    private DataProxyClusterService dataProxyClusterService;
    @Autowired
    private ThirdPartyClusterService thirdPartyClusterService;

    @RequestMapping(value={"/getIpList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ApiOperation(value="Get data proxy ip list by cluster name")
    public Response<List<DataProxyResponse>> getIpList(@RequestParam(required=false) String clusterName) {
        return Response.success((Object)this.thirdPartyClusterService.getIpList(clusterName));
    }

    @GetMapping(value={"/getConfig"})
    @ApiOperation(value="Get data proxy topic list")
    public Response<List<DataProxyConfig>> getConfig() {
        return Response.success((Object)this.thirdPartyClusterService.getConfig());
    }

    @GetMapping(value={"/getConfig_v2"})
    @ApiOperation(value="Get data proxy list - including topic")
    public Response<ThirdPartyClusterDTO> getConfigV2(@RequestParam(value="clusterName") String clusterName) {
        ThirdPartyClusterDTO dto = this.thirdPartyClusterService.getConfigV2(clusterName);
        if (dto.getMqSet().isEmpty() || dto.getTopicList().isEmpty()) {
            return Response.fail((String)"failed to get mq config or topics");
        }
        return Response.success((Object)dto);
    }

    @GetMapping(value={"/getAllConfig"})
    @ApiOperation(value="Get all proxy config")
    public String getAllConfig(@RequestParam(value="clusterName") String clusterName, @RequestParam(value="setName") String setName, @RequestParam(value="md5", required=false) String md5) {
        return this.dataProxyClusterService.getAllConfig(clusterName, setName, md5);
    }
}

