/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.apache.inlong.manager.pojo.audit.AuditBaseResponse;
import org.apache.inlong.manager.pojo.audit.AuditRequest;
import org.apache.inlong.manager.pojo.audit.AuditSourceRequest;
import org.apache.inlong.manager.pojo.audit.AuditSourceResponse;
import org.apache.inlong.manager.pojo.audit.AuditVO;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.core.AuditService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Audit-API"})
public class AuditController {
    @Lazy
    @Autowired
    private AuditService auditService;

    @PostMapping(value={"/audit/list"})
    @ApiOperation(value="Query audit list according to conditions")
    public Response<List<AuditVO>> listByCondition(@Valid @RequestBody AuditRequest request) throws Exception {
        return Response.success((Object)this.auditService.listByCondition(request));
    }

    @ApiOperation(value="Refresh audit base item cache")
    @PostMapping(value={"/audit/refreshCache"})
    public Response<Boolean> refreshCache() {
        return Response.success((Object)this.auditService.refreshBaseItemCache());
    }

    @ApiOperation(value="Update the audit source")
    @PostMapping(value={"/audit/updateSource"})
    public Response<Integer> updateAuditSource(@Valid @RequestBody AuditSourceRequest request) {
        return Response.success((Object)this.auditService.updateAuditSource(request, LoginUserUtils.getLoginUser().getName()));
    }

    @ApiOperation(value="Get the audit base info")
    @GetMapping(value={"/audit/getAuditBases"})
    public Response<List<AuditBaseResponse>> getAuditBases() {
        return Response.success((Object)this.auditService.getAuditBases());
    }

    @ApiOperation(value="Get the audit source")
    @GetMapping(value={"/audit/getSource"})
    public Response<AuditSourceResponse> getAuditSource() {
        return Response.success((Object)this.auditService.getAuditSource());
    }
}

