/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateByIdValidation;
import org.apache.inlong.manager.common.validation.UpdateByKeyValidation;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.cluster.BindTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeResponse;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagPageRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagResponse;
import org.apache.inlong.manager.pojo.cluster.TenantClusterTagInfo;
import org.apache.inlong.manager.pojo.cluster.TenantClusterTagPageRequest;
import org.apache.inlong.manager.pojo.cluster.TenantClusterTagRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.common.UpdateResult;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Api(tags={"Inlong-Cluster-API"})
public class InlongClusterController {
    @Autowired
    private InlongClusterService clusterService;

    @PostMapping(value={"/cluster/tag/save"})
    @ApiOperation(value="Save cluster tag")
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.CLUSTER)
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Integer> saveTag(@Validated(value={SaveValidation.class}) @RequestBody ClusterTagRequest request) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.saveTag(request, currentUser));
    }

    @GetMapping(value={"/cluster/tag/get/{id}"})
    @ApiOperation(value="Get cluster tag by id")
    @ApiImplicitParam(name="id", value="Cluster ID", dataTypeClass=Integer.class, required=true)
    public Response<ClusterTagResponse> getTag(@PathVariable Integer id) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.getTag(id, currentUser));
    }

    @PostMapping(value={"/cluster/tag/list"})
    @ApiOperation(value="List cluster tags")
    public Response<PageResult<ClusterTagResponse>> listTag(@RequestBody ClusterTagPageRequest request) {
        request.setCurrentUser(LoginUserUtils.getLoginUser().getName());
        request.setIsAdminRole(Boolean.valueOf(LoginUserUtils.isInlongAdminOrTenantAdmin()));
        return Response.success((Object)this.clusterService.listTag(request));
    }

    @PostMapping(value={"/cluster/tag/update"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.CLUSTER)
    @ApiOperation(value="Update cluster tag")
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Boolean> updateTag(@Validated(value={UpdateValidation.class}) @RequestBody ClusterTagRequest request) {
        String username = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.updateTag(request, username));
    }

    @DeleteMapping(value={"/cluster/tag/delete/{id}"})
    @ApiOperation(value="Delete cluster tag by id")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.CLUSTER)
    @ApiImplicitParam(name="id", value="Cluster tag ID", dataTypeClass=Integer.class, required=true)
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Boolean> deleteTag(@PathVariable Integer id) {
        return Response.success((Object)this.clusterService.deleteTag(id, LoginUserUtils.getLoginUser().getName()));
    }

    @PostMapping(value={"/cluster/tenant/tag/save"})
    @ApiOperation(value="Save tenant cluster tag")
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.CLUSTER)
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Integer> saveTenantTag(@Validated(value={SaveValidation.class}) @RequestBody TenantClusterTagRequest request) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.saveTenantTag(request, currentUser));
    }

    @PostMapping(value={"/cluster/tenant/tag/list"})
    @ApiOperation(value="List tenant cluster tags")
    public Response<PageResult<TenantClusterTagInfo>> listTenantTag(@RequestBody TenantClusterTagPageRequest request) {
        return Response.success((Object)this.clusterService.listTenantTag(request));
    }

    @PostMapping(value={"/cluster/tag/listTagByTenantRole"})
    @ApiOperation(value="List cluster tags by tenant condition")
    public Response<PageResult<ClusterTagResponse>> listTagByTenantRole(@RequestBody TenantClusterTagPageRequest request) {
        return Response.success((Object)this.clusterService.listTagByTenantRole(request));
    }

    @PostMapping(value={"/cluster/listByTenantRole"})
    @ApiOperation(value="List cluster by tenant condition")
    public Response<PageResult<ClusterInfo>> listByTenantRole(@RequestBody ClusterPageRequest request) {
        return Response.success((Object)this.clusterService.listByTenantRole(request));
    }

    @DeleteMapping(value={"/cluster/tenant/tag/delete/{id}"})
    @ApiOperation(value="Delete tenant cluster tag by id")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.CLUSTER)
    @ApiImplicitParam(name="id", value="Cluster tag ID", dataTypeClass=Integer.class, required=true)
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Boolean> deleteTenantTag(@PathVariable Integer id) {
        return Response.success((Object)this.clusterService.deleteTenantTag(id, LoginUserUtils.getLoginUser().getName()));
    }

    @PostMapping(value={"/cluster/save"})
    @ApiOperation(value="Save cluster")
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.CLUSTER)
    @RequiresRoles(logical=Logical.OR, value={"INLONG_ADMIN", "TENANT_ADMIN"})
    public Response<Integer> save(@Validated(value={SaveValidation.class}) @RequestBody ClusterRequest request) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.save(request, currentUser));
    }

    @GetMapping(value={"/cluster/get/{id}"})
    @ApiOperation(value="Get cluster by id")
    @ApiImplicitParam(name="id", value="Cluster ID", dataTypeClass=Integer.class, required=true)
    public Response<ClusterInfo> get(@PathVariable Integer id) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.get(id, currentUser));
    }

    @PostMapping(value={"/cluster/list"})
    @ApiOperation(value="List clusters")
    public Response<PageResult<ClusterInfo>> list(@RequestBody ClusterPageRequest request) {
        request.setCurrentUser(LoginUserUtils.getLoginUser().getName());
        request.setIsAdminRole(Boolean.valueOf(LoginUserUtils.isInlongAdminOrTenantAdmin()));
        return Response.success((Object)this.clusterService.list(request));
    }

    @PostMapping(value={"/cluster/update"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.CLUSTER)
    @ApiOperation(value="Update cluster")
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Boolean> update(@Validated(value={UpdateByIdValidation.class}) @RequestBody ClusterRequest request) {
        String username = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.update(request, username));
    }

    @PostMapping(value={"/cluster/updateByKey"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.CLUSTER)
    @ApiOperation(value="Update cluster by key")
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<UpdateResult> updateByKey(@Validated(value={UpdateByKeyValidation.class}) @RequestBody ClusterRequest request) {
        String username = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.updateByKey(request, username));
    }

    @PostMapping(value={"/cluster/bindTag"})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.CLUSTER)
    @ApiOperation(value="Bind or unbind cluster tag")
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Boolean> bindTag(@Validated @RequestBody BindTagRequest request) {
        String username = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.bindTag(request, username));
    }

    @DeleteMapping(value={"/cluster/delete/{id}"})
    @ApiOperation(value="Delete cluster by id")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.CLUSTER)
    @ApiImplicitParam(name="id", value="Cluster ID", dataTypeClass=Integer.class, required=true)
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Boolean> delete(@PathVariable Integer id) {
        return Response.success((Object)this.clusterService.delete(id, LoginUserUtils.getLoginUser().getName()));
    }

    @DeleteMapping(value={"/cluster/deleteByKey"})
    @ApiOperation(value="Delete cluster by cluster name and type")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.CLUSTER)
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="Cluster name", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="type", value="Cluster type", dataTypeClass=String.class, required=true)})
    @RequiresRoles(value={"INLONG_ADMIN"})
    public Response<Boolean> deleteByKey(@RequestParam String name, @RequestParam String type) {
        return Response.success((Object)this.clusterService.deleteByKey(name, type, LoginUserUtils.getLoginUser().getName()));
    }

    @PostMapping(value={"/cluster/node/save"})
    @ApiOperation(value="Save cluster node")
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.CLUSTER)
    public Response<Integer> saveNode(@Validated @RequestBody ClusterNodeRequest request) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.saveNode(request, currentUser));
    }

    @GetMapping(value={"/cluster/node/get/{id}"})
    @ApiOperation(value="Get cluster node by id")
    @ApiImplicitParam(name="id", value="Cluster node ID", dataTypeClass=Integer.class, required=true)
    public Response<ClusterNodeResponse> getNode(@PathVariable Integer id) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.getNode(id, currentUser));
    }

    @PostMapping(value={"/cluster/node/list"})
    @ApiOperation(value="List cluster nodes by pagination")
    public Response<PageResult<ClusterNodeResponse>> listNode(@RequestBody ClusterPageRequest request) {
        String currentUser = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.listNode(request, currentUser));
    }

    @GetMapping(value={"/cluster/node/listByGroupId"})
    @ApiOperation(value="List cluster nodes by groupId, clusterType and protocolType")
    @ApiImplicitParams(value={@ApiImplicitParam(name="inlongGroupId", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="clusterType", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="protocolType", dataTypeClass=String.class, required=false)})
    @OperationLog(operation=OperationType.GET, operationTarget=OperationTarget.CLUSTER)
    public Response<List<ClusterNodeResponse>> listByGroupId(@RequestParam String inlongGroupId, @RequestParam String clusterType, @RequestParam(required=false) String protocolType) {
        return Response.success((Object)this.clusterService.listNodeByGroupId(inlongGroupId, clusterType, protocolType));
    }

    @RequestMapping(value={"/cluster/node/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.CLUSTER)
    @ApiOperation(value="Update cluster node")
    public Response<Boolean> updateNode(@Validated(value={UpdateValidation.class}) @RequestBody ClusterNodeRequest request) {
        String username = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.clusterService.updateNode(request, username));
    }

    @RequestMapping(value={"/cluster/node/delete/{id}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete cluster node")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.CLUSTER)
    @ApiImplicitParam(name="id", value="Cluster node ID", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> deleteNode(@PathVariable Integer id) {
        return Response.success((Object)this.clusterService.deleteNode(id, LoginUserUtils.getLoginUser().getName()));
    }

    @RequestMapping(value={"/cluster/node/unload/{id}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete cluster node")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.CLUSTER)
    @ApiImplicitParam(name="id", value="Cluster node ID", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> unloadNode(@PathVariable Integer id) {
        return Response.success((Object)this.clusterService.unloadNode(id, LoginUserUtils.getLoginUser().getName()));
    }

    @PostMapping(value={"/cluster/testConnection"})
    @ApiOperation(value="Test connection for inlong cluster")
    public Response<Boolean> testConnection(@Validated @RequestBody ClusterRequest request) {
        return Response.success((Object)this.clusterService.testConnection(request));
    }
}

