/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.OperationTarget;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.common.BatchResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.group.InlongGroupBriefInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.group.InlongGroupProcessService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.operationlog.OperationLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-InLongGroup-API"})
public class OpenInLongGroupController {
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongGroupProcessService groupProcessOperation;

    @GetMapping(value={"/group/get/{groupId}"})
    @ApiOperation(value="Get InLong group information by groupId")
    @ApiImplicitParam(name="groupId", value="InLong Group ID", dataTypeClass=String.class, required=true)
    public Response<InlongGroupInfo> get(@PathVariable String groupId) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"groupId cannot be blank");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.groupService.get(groupId));
    }

    @PostMapping(value={"/group/list"})
    @ApiOperation(value="List inlong groups by paginating")
    public Response<List<InlongGroupBriefInfo>> listBrief(@RequestBody InlongGroupPageRequest request) {
        Preconditions.expectNotNull((Object)request, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.groupService.listBrief(request, LoginUserUtils.getLoginUser()));
    }

    @RequestMapping(value={"/group/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.GROUP)
    @ApiOperation(value="Save inlong group")
    public Response<String> save(@Validated(value={SaveValidation.class}) @RequestBody InlongGroupRequest groupRequest) {
        Preconditions.expectNotNull((Object)groupRequest, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.groupService.save(groupRequest, LoginUserUtils.getLoginUser().getName()));
    }

    @RequestMapping(value={"/group/batchSave"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE, operationTarget=OperationTarget.GROUP)
    @ApiOperation(value="Batch Save inlong group")
    public Response<List<BatchResult>> batchSave(@Validated(value={SaveValidation.class}) @RequestBody List<InlongGroupRequest> groupRequestList) {
        String operator = LoginUserUtils.getLoginUser().getName();
        return Response.success((Object)this.groupService.batchSave(groupRequestList, operator));
    }

    @RequestMapping(value={"/group/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE, operationTarget=OperationTarget.GROUP)
    @ApiOperation(value="Update inlong group")
    public Response<String> update(@Validated(value={UpdateValidation.class}) @RequestBody InlongGroupRequest groupRequest) {
        Preconditions.expectNotNull((Object)groupRequest, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"request cannot be null");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.groupService.update(groupRequest, LoginUserUtils.getLoginUser().getName()));
    }

    @RequestMapping(value={"/group/delete/{groupId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="Delete inlong group info")
    @OperationLog(operation=OperationType.DELETE, operationTarget=OperationTarget.GROUP)
    @ApiImplicitParam(name="groupId", value="Inlong group id", dataTypeClass=String.class, required=true)
    public Response<Boolean> delete(@PathVariable String groupId) {
        Preconditions.expectNotBlank((String)groupId, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"groupId cannot be blank");
        Preconditions.expectNotNull((Object)LoginUserUtils.getLoginUser(), (ErrorCodeEnum)ErrorCodeEnum.LOGIN_USER_EMPTY);
        return Response.success((Object)this.groupProcessOperation.deleteProcess(groupId, LoginUserUtils.getLoginUser()));
    }
}

