/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth.impl;

import java.util.LinkedHashMap;
import org.apache.inlong.manager.common.auth.InlongShiro;
import org.apache.inlong.manager.service.core.UserService;
import org.apache.inlong.manager.web.auth.AuthenticationFilter;
import org.apache.inlong.manager.web.auth.WebAuthorizingRealm;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.session.mgt.WebSessionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"type"}, prefix="inlong.auth", havingValue="default")
@Component
public class InlongShiroImpl
implements InlongShiro {
    @Autowired
    private UserService userService;

    public WebSecurityManager getWebSecurityManager() {
        return new DefaultWebSecurityManager();
    }

    public AuthorizingRealm getShiroRealm() {
        return new WebAuthorizingRealm(this.userService);
    }

    public WebSessionManager getWebSessionManager() {
        return new DefaultWebSessionManager();
    }

    public CredentialsMatcher getCredentialsMatcher() {
        HashedCredentialsMatcher hashedCredentialsMatcher = new HashedCredentialsMatcher();
        hashedCredentialsMatcher.setHashAlgorithmName("MD5");
        hashedCredentialsMatcher.setHashIterations(1024);
        return hashedCredentialsMatcher;
    }

    public ShiroFilterFactoryBean getShiroFilter(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        LinkedHashMap<String, AuthenticationFilter> filters = new LinkedHashMap<String, AuthenticationFilter>();
        filters.put("authc", new AuthenticationFilter());
        shiroFilterFactoryBean.setFilters(filters);
        LinkedHashMap<String, String> pathDefinitions = new LinkedHashMap<String, String>();
        pathDefinitions.put("/anno/**/*", "anon");
        pathDefinitions.put("/doc.html", "anon");
        pathDefinitions.put("/v2/api-docs/**/**", "anon");
        pathDefinitions.put("/webjars/**/*", "anon");
        pathDefinitions.put("/swagger-resources/**/*", "anon");
        pathDefinitions.put("/swagger-resources", "anon");
        pathDefinitions.put("/openapi/**/*", "anon");
        pathDefinitions.put("/**", "authc");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(pathDefinitions);
        return shiroFilterFactoryBean;
    }

    public AuthorizationAttributeSourceAdvisor getAuthorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }
}

