/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.config;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.pojo.user.UserDetail;
import org.apache.inlong.manager.common.util.LoginUserUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionHandler.class);
    private static final String ERROR_MSG = "failed to handle request on path: %s by user: %s";

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Response<String> handleConstraintViolationException(HttpServletRequest request, ConstraintViolationException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        String username = userDetail != null ? userDetail.getUserName() : "";
        log.error(String.format(ERROR_MSG, request.getRequestURI(), username), (Throwable)e);
        Set violations = e.getConstraintViolations();
        StringBuilder stringBuilder = new StringBuilder(64);
        for (ConstraintViolation violation : violations) {
            stringBuilder.append(violation.getMessage()).append(".");
        }
        return Response.fail((String)stringBuilder.toString());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Response<String> handleMethodArgumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        String username = userDetail != null ? userDetail.getUserName() : "";
        log.error(String.format(ERROR_MSG, request.getRequestURI(), username), (Throwable)e);
        StringBuilder builder = new StringBuilder();
        BindingResult result = e.getBindingResult();
        result.getFieldErrors().forEach(error -> builder.append(error.getField()).append(":").append(error.getDefaultMessage()).append(System.lineSeparator()));
        result.getGlobalErrors().forEach(error -> builder.append(error.getDefaultMessage()).append(System.lineSeparator()));
        return Response.fail((String)builder.toString());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Response<String> handleIllegalArgumentException(HttpServletRequest request, IllegalArgumentException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        String username = userDetail != null ? userDetail.getUserName() : "";
        log.error(String.format(ERROR_MSG, request.getRequestURI(), username), (Throwable)e);
        return Response.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public Response<String> handleBindExceptionHandler(HttpServletRequest request, BindException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        String username = userDetail != null ? userDetail.getUserName() : "";
        log.error(String.format(ERROR_MSG, request.getRequestURI(), username), (Throwable)e);
        StringBuilder builder = new StringBuilder();
        e.getBindingResult().getFieldErrors().forEach(error -> builder.append(error.getField()).append(":").append(error.getDefaultMessage()).append(System.lineSeparator()));
        return Response.fail((String)builder.toString());
    }

    @ExceptionHandler(value={HttpMessageConversionException.class})
    public Response<String> handleHttpMessageConversionExceptionHandler(HttpServletRequest request, HttpMessageConversionException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        String username = userDetail != null ? userDetail.getUserName() : "";
        log.error(String.format(ERROR_MSG, request.getRequestURI(), username), (Throwable)e);
        return Response.fail((String)"http message convert exception! pls check params");
    }

    @ExceptionHandler(value={WorkflowException.class})
    public Response<String> handleWorkflowException(HttpServletRequest request, WorkflowException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        String username = userDetail != null ? userDetail.getUserName() : "";
        log.error(String.format(ERROR_MSG, request.getRequestURI(), username), (Throwable)e);
        return Response.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={BusinessException.class})
    public Response<String> handleBusinessExceptionHandler(HttpServletRequest request, BusinessException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        String username = userDetail != null ? userDetail.getUserName() : "";
        log.error(String.format(ERROR_MSG, request.getRequestURI(), username), (Throwable)e);
        return Response.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public Response<String> handleAuthenticationException(HttpServletRequest request, AuthenticationException e) {
        log.error(String.format(ERROR_MSG, request.getRequestURI(), ""), (Throwable)e);
        return Response.fail((String)"Username or password was incorrect, or the account has expired");
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public Response<String> handleUnauthorizedException(HttpServletRequest request, AuthorizationException e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        String username = userDetail != null ? userDetail.getUserName() : "";
        log.error(String.format(ERROR_MSG, request.getRequestURI(), username), (Throwable)e);
        return Response.fail((String)String.format("Current user [%s] has no permission to access URL", userDetail != null ? userDetail.getUserName() : ""));
    }

    @ExceptionHandler(value={Exception.class})
    public Response<String> handle(HttpServletRequest request, Exception e) {
        UserDetail userDetail = LoginUserUtils.getLoginUserDetail();
        String username = userDetail != null ? userDetail.getUserName() : "";
        log.error(String.format(ERROR_MSG, request.getRequestURI(), username), (Throwable)e);
        return Response.fail((String)"There was an error in the service...Please try again later! If there are still problems, please contact the administrator");
    }
}

