/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.pojo.user.LoginUser;
import org.apache.inlong.manager.common.pojo.user.UserDetail;
import org.apache.inlong.manager.common.pojo.user.UserInfo;
import org.apache.inlong.manager.common.util.LoginUserUtils;
import org.apache.inlong.manager.service.core.UserService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/anno"})
@Api(tags={"User - Anno (No Auth)"})
public class AnnoController {
    private static final Logger log = LoggerFactory.getLogger(AnnoController.class);
    @Autowired
    UserService userService;

    @PostMapping(value={"/login"})
    public Response<String> login(@RequestBody LoginUser loginUser) {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(loginUser.getUsername(), loginUser.getPassword());
        subject.login((AuthenticationToken)token);
        LoginUserUtils.setUserLoginInfo((UserDetail)((UserDetail)subject.getPrincipal()));
        return Response.success((Object)"success");
    }

    @PostMapping(value={"/doRegister"})
    public Response<Boolean> doRegister(@RequestBody UserInfo userInfo) {
        userInfo.checkValid();
        return Response.success((Object)this.userService.create(userInfo));
    }

    @GetMapping(value={"/logout"})
    public Response<String> logout() {
        SecurityUtils.getSubject().logout();
        return Response.success((Object)"success");
    }
}

