/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.pojo.heartbeat.ComponentHeartbeatResponse;
import org.apache.inlong.manager.common.pojo.heartbeat.GroupHeartbeatResponse;
import org.apache.inlong.manager.common.pojo.heartbeat.HeartbeatPageRequest;
import org.apache.inlong.manager.common.pojo.heartbeat.HeartbeatQueryRequest;
import org.apache.inlong.manager.common.pojo.heartbeat.StreamHeartbeatResponse;
import org.apache.inlong.manager.service.core.HeartbeatService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/heartbeat"})
@Api(tags={"Heartbeat-API"})
public class HeartbeatController {
    @Autowired
    private HeartbeatService heartbeatService;

    @RequestMapping(value={"/component/get"}, method={RequestMethod.POST})
    @ApiOperation(value="Get component heartbeat")
    public Response<ComponentHeartbeatResponse> getComponentHeartbeat(@RequestBody HeartbeatQueryRequest request) {
        return Response.success((Object)this.heartbeatService.getComponentHeartbeat(request));
    }

    @RequestMapping(value={"/group/get"}, method={RequestMethod.POST})
    @ApiOperation(value="Get group heartbeat")
    public Response<GroupHeartbeatResponse> getGroupHeartbeat(@RequestBody HeartbeatQueryRequest request) {
        return Response.success((Object)this.heartbeatService.getGroupHeartbeat(request));
    }

    @RequestMapping(value={"/stream/get"}, method={RequestMethod.POST})
    @ApiOperation(value="Get stream heartbeat")
    public Response<StreamHeartbeatResponse> getStreamHeartbeat(@RequestBody HeartbeatQueryRequest request) {
        return Response.success((Object)this.heartbeatService.getStreamHeartbeat(request));
    }

    @RequestMapping(value={"/component/list"}, method={RequestMethod.POST})
    @ApiOperation(value="List component heartbeats")
    public Response<PageInfo<ComponentHeartbeatResponse>> listComponentHeartbeat(@RequestBody HeartbeatPageRequest request) {
        return Response.success((Object)this.heartbeatService.listComponentHeartbeat(request));
    }

    @RequestMapping(value={"/group/list"}, method={RequestMethod.POST})
    @ApiOperation(value="List group heartbeats")
    public Response<PageInfo<GroupHeartbeatResponse>> listGroupHeartbeat(@RequestBody HeartbeatPageRequest request) {
        return Response.success((Object)this.heartbeatService.listGroupHeartbeat(request));
    }

    @RequestMapping(value={"/stream/list"}, method={RequestMethod.POST})
    @ApiOperation(value="List stream heartbeats")
    public Response<PageInfo<StreamHeartbeatResponse>> listStreamHeartbeat(@RequestBody HeartbeatPageRequest request) {
        return Response.success((Object)this.heartbeatService.listStreamHeartbeat(request));
    }
}

