/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.sink.SinkListResponse;
import org.apache.inlong.manager.common.pojo.sink.SinkPageRequest;
import org.apache.inlong.manager.common.pojo.sink.SinkRequest;
import org.apache.inlong.manager.common.pojo.sink.StreamSink;
import org.apache.inlong.manager.common.util.LoginUserUtils;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sink"})
@Api(tags={"Stream sink config"})
public class StreamSinkController {
    @Autowired
    private StreamSinkService sinkService;

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save sink information")
    public Response<Integer> save(@Validated @RequestBody SinkRequest request) {
        return Response.success((Object)this.sinkService.save(request, LoginUserUtils.getLoginUserDetail().getUserName()));
    }

    @RequestMapping(value={"/get/{id}"}, method={RequestMethod.GET})
    @ApiOperation(value="Query sink information")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    public Response<StreamSink> get(@PathVariable Integer id) {
        return Response.success((Object)this.sinkService.get(id));
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ApiOperation(value="Query stream sink list based on conditions")
    public Response<PageInfo<? extends SinkListResponse>> listByCondition(SinkPageRequest request) {
        return Response.success((Object)this.sinkService.listByCondition(request));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Modify data sink information")
    public Response<Boolean> update(@Validated @RequestBody SinkRequest request) {
        return Response.success((Object)this.sinkService.update(request, LoginUserUtils.getLoginUserDetail().getUserName()));
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    @OperationLog(operation=OperationType.DELETE)
    @ApiOperation(value="Delete data sink information")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> delete(@PathVariable Integer id) {
        boolean result = this.sinkService.delete(id, LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)result);
    }
}

