/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.source.SourceListResponse;
import org.apache.inlong.manager.common.pojo.source.SourcePageRequest;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.util.LoginUserUtils;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/source"})
@Api(tags={"Stream source config"})
public class StreamSourceController {
    @Autowired
    StreamSourceService sourceService;

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save stream source")
    public Response<Integer> save(@Validated @RequestBody SourceRequest request) {
        return Response.success((Object)this.sourceService.save(request, LoginUserUtils.getLoginUserDetail().getUserName()));
    }

    @RequestMapping(value={"/get/{id}"}, method={RequestMethod.GET})
    @ApiOperation(value="Query stream source")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    public Response<StreamSource> get(@PathVariable Integer id) {
        return Response.success((Object)this.sourceService.get(id));
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ApiOperation(value="Query stream source list")
    public Response<PageInfo<? extends SourceListResponse>> listByCondition(SourcePageRequest request) {
        return Response.success((Object)this.sourceService.listByCondition(request));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Modify stream source")
    public Response<Boolean> update(@Validated @RequestBody SourceRequest request) {
        return Response.success((Object)this.sourceService.update(request, LoginUserUtils.getLoginUserDetail().getUserName()));
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    @OperationLog(operation=OperationType.DELETE)
    @ApiOperation(value="Delete stream source")
    @ApiImplicitParam(name="id", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> delete(@PathVariable Integer id) {
        boolean result = this.sourceService.delete(id, LoginUserUtils.getLoginUserDetail().getUserName());
        return Response.success((Object)result);
    }
}

