/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.transform.TransformRequest;
import org.apache.inlong.manager.common.pojo.transform.TransformResponse;
import org.apache.inlong.manager.common.util.LoginUserUtils;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.apache.inlong.manager.service.transform.StreamTransformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/transform"})
@Api(tags={"Stream transform config"})
public class StreamTransformController {
    private static final Logger log = LoggerFactory.getLogger(StreamTransformController.class);
    @Autowired
    protected StreamTransformService streamTransformService;

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.CREATE)
    @ApiOperation(value="Save stream transform")
    public Response<Integer> save(@Validated @RequestBody TransformRequest request) {
        return Response.success((Object)this.streamTransformService.save(request, LoginUserUtils.getLoginUserDetail().getUserName()));
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ApiOperation(value="Query stream transform list")
    public Response<List<TransformResponse>> list(@RequestParam(value="inlongGroupId") String groupId, @RequestParam(value="inlongStreamId") String streamId) {
        return Response.success((Object)this.streamTransformService.listTransform(groupId, streamId));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Modify stream source")
    public Response<Boolean> update(@Validated @RequestBody TransformRequest request) {
        return Response.success((Object)this.streamTransformService.update(request, LoginUserUtils.getLoginUserDetail().getUserName()));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Modify stream source")
    public Response<Boolean> delete(@RequestParam(value="inlongGroupId") String groupId, @RequestParam(value="inlongStreamId") String streamId, @RequestParam(value="transformName") String transformName) {
        return Response.success((Object)this.streamTransformService.delete(groupId, streamId, transformName, LoginUserUtils.getLoginUserDetail().getUserName()));
    }
}

