/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.workflow.EventLogQuery;
import org.apache.inlong.manager.common.pojo.workflow.EventLogView;
import org.apache.inlong.manager.service.core.WorkflowEventService;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/event"})
@Api(tags={"Workflow Event"})
public class WorkflowEventController {
    @Autowired
    private WorkflowEventService workflowEventService;

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="Get event details")
    @ApiImplicitParam(name="id", value="event id", dataTypeClass=Integer.class, required=true)
    public Response<EventLogView> get(@PathVariable Integer id) {
        return Response.success((Object)this.workflowEventService.get(id));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="Query event list based on conditions")
    public Response<PageInfo<EventLogView>> list(EventLogQuery query) {
        return Response.success((Object)this.workflowEventService.list(query));
    }

    @PostMapping(value={"executeEventListener/{id}"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Execute the listener based on the log ID")
    @ApiImplicitParam(name="id", value="event id", dataTypeClass=Integer.class, required=true)
    public Response<Object> executeEventListener(@PathVariable Integer id) {
        this.workflowEventService.executeEventListener(id);
        return Response.success();
    }

    @PostMapping(value={"executeProcessEventListener"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Re-execute the specified listener according to the process ID")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processId", value="process id", dataTypeClass=Integer.class), @ApiImplicitParam(name="listenerName", value="listener name", dataTypeClass=String.class)})
    public Response<Object> executeProcessEventListener(@RequestParam Integer processId, @RequestParam String listenerName) {
        this.workflowEventService.executeProcessEventListener(processId, listenerName);
        return Response.success();
    }

    @PostMapping(value={"executeTaskEventListener"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Re-execute the specified listener based on the task ID")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="task id", dataTypeClass=Integer.class), @ApiImplicitParam(name="listenerName", value="listener name", dataTypeClass=String.class)})
    public Response<Object> executeTaskEventListener(Integer taskId, String listenerName) {
        this.workflowEventService.executeTaskEventListener(taskId, listenerName);
        return Response.success();
    }

    @PostMapping(value={"triggerProcessEvent"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Re-trigger the process event based on the process ID")
    public Response<Object> triggerProcessEvent(@ApiParam(value="process id", required=true) Integer processId, @ApiParam(value="process event", required=true) ProcessEvent processEvent) {
        this.workflowEventService.triggerProcessEvent(processId, processEvent);
        return Response.success();
    }

    @PostMapping(value={"triggerTaskEvent"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Re-trigger the task event based on the task ID")
    public Response<Object> triggerTaskEvent(@ApiParam(value="task id", required=true) Integer taskId, @ApiParam(value="task event", required=true) TaskEvent taskEvent) {
        this.workflowEventService.triggerTaskEvent(taskId, taskEvent);
        return Response.success();
    }
}

