/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfig;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.pojo.dataproxy.DataProxyNodeInfo;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi"})
@Api(tags={"Open-DataProxy-Config"})
public class DataProxyController {
    @Autowired
    private InlongClusterService clusterService;

    @RequestMapping(value={"/dataproxy/getIpList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ApiOperation(value="Get data proxy ip list by cluster name")
    @ApiImplicitParams(value={@ApiImplicitParam(name="clusterTag", value="cluster tag", dataTypeClass=String.class), @ApiImplicitParam(name="clusterName", value="cluster name", dataTypeClass=String.class)})
    public Response<List<DataProxyNodeInfo>> getIpList(@RequestParam(required=false) String clusterTag, @RequestParam(required=false) String clusterName) {
        return Response.success((Object)this.clusterService.getDataProxyNodeList(clusterTag, clusterName));
    }

    @GetMapping(value={"/dataproxy/getConfig"})
    @ApiOperation(value="Get data proxy topic list")
    @ApiImplicitParams(value={@ApiImplicitParam(name="clusterTag", value="cluster tag", dataTypeClass=String.class), @ApiImplicitParam(name="clusterName", value="cluster name", dataTypeClass=String.class)})
    public Response<DataProxyConfig> getConfig(@RequestParam(required=false) String clusterTag, @RequestParam(required=true) String clusterName) {
        DataProxyConfig config = this.clusterService.getDataProxyConfig(clusterTag, clusterName);
        if (CollectionUtils.isEmpty((Collection)config.getMqClusterList()) || CollectionUtils.isEmpty((Collection)config.getTopicList())) {
            return Response.fail((String)"failed to get mq clusters or topics");
        }
        return Response.success((Object)config);
    }

    @GetMapping(value={"/dataproxy/getAllConfig"})
    @ApiOperation(value="Get all proxy config")
    @ApiImplicitParams(value={@ApiImplicitParam(name="clusterName", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="md5", dataTypeClass=String.class, required=true)})
    public String getAllConfig(@RequestParam String clusterName, @RequestParam(required=false) String md5) {
        return this.clusterService.getAllConfig(clusterName, md5);
    }
}

