/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.controller.openapi;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.apache.inlong.manager.common.beans.Response;
import org.apache.inlong.manager.common.enums.OperationType;
import org.apache.inlong.manager.common.pojo.cluster.InlongClusterInfo;
import org.apache.inlong.manager.common.pojo.cluster.InlongClusterPageRequest;
import org.apache.inlong.manager.common.pojo.cluster.InlongClusterRequest;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.core.operationlog.OperationLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openapi/cluster"})
@Api(tags={"Open-Cluster-API"})
public class OpenClusterController {
    @Autowired
    private InlongClusterService clusterService;

    @PostMapping(value={"/save"})
    @ApiOperation(value="Save cluster info")
    @OperationLog(operation=OperationType.CREATE)
    public Response<Integer> save(@RequestBody InlongClusterRequest request) {
        return Response.success((Object)this.clusterService.save(request, null));
    }

    @GetMapping(value={"/get/{id}"})
    @ApiOperation(value="Get cluster by id")
    @ApiImplicitParam(name="id", value="common cluster ID", dataTypeClass=Integer.class, required=true)
    public Response<InlongClusterInfo> get(@PathVariable Integer id) {
        return Response.success((Object)this.clusterService.get(id));
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="Get clusters by paginating")
    public Response<PageInfo<InlongClusterInfo>> list(@RequestBody InlongClusterPageRequest request) {
        return Response.success((Object)this.clusterService.list(request));
    }

    @PostMapping(value={"/update"})
    @OperationLog(operation=OperationType.UPDATE)
    @ApiOperation(value="Update cluster info")
    public Response<Boolean> update(@RequestBody InlongClusterRequest request) {
        return Response.success((Object)this.clusterService.update(request, null));
    }

    @DeleteMapping(value={"/delete/{id}"})
    @ApiOperation(value="Delete cluster by id")
    @OperationLog(operation=OperationType.DELETE)
    @ApiImplicitParam(name="id", value="Cluster ID", dataTypeClass=Integer.class, required=true)
    public Response<Boolean> delete(@PathVariable Integer id) {
        return Response.success((Object)this.clusterService.delete(id, null));
    }
}

