/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowEventLogEntity;
import org.apache.inlong.manager.dao.mapper.WorkflowEventLogEntityMapper;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.core.EventListenerService;
import org.apache.inlong.manager.workflow.core.WorkflowContextBuilder;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.event.process.ProcessEventNotifier;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventNotifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventListenerServiceImpl
implements EventListenerService {
    @Autowired
    private WorkflowContextBuilder workflowContextBuilder;
    @Autowired
    private ProcessEventNotifier processEventNotifier;
    @Autowired
    private TaskEventNotifier taskEventNotifier;
    @Autowired
    private WorkflowEventLogEntityMapper eventLogMapper;

    @Override
    public void executeEventListener(Integer eventLogId) {
        WorkflowEventLogEntity eventLogEntity = this.eventLogMapper.selectById(eventLogId);
        Preconditions.checkNotNull((Object)eventLogEntity, (String)("event log not exist with id: " + eventLogId));
        if (ProcessEvent.class.getSimpleName().equals(eventLogEntity.getEventType())) {
            this.executeProcessEventListener(eventLogEntity.getProcessId(), eventLogEntity.getListener());
            return;
        }
        if (TaskEvent.class.getSimpleName().equals(eventLogEntity.getEventType())) {
            this.executeTaskEventListener(eventLogEntity.getTaskId(), eventLogEntity.getListener());
            return;
        }
        throw new WorkflowException("unknown event type: " + eventLogEntity.getEventType());
    }

    @Override
    public void executeProcessEventListener(Integer processId, String listenerName) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForProcess(processId);
        ProcessEvent processEvent = (ProcessEvent)this.getProcessEventListener(context.getProcess(), listenerName).event();
        context.setCurrentElement(this.getCurrentElement(context.getProcess(), processEvent));
        this.processEventNotifier.notify(listenerName, context);
    }

    @Override
    public void executeTaskEventListener(Integer taskId, String listenerName) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskId, null);
        TaskEventListener eventListener = this.getTaskEventListener((WorkflowTask)context.getCurrentElement(), listenerName);
        context.getActionContext().setAction(WorkflowAction.fromTaskEvent((TaskEvent)eventListener.event()));
        this.taskEventNotifier.notify(listenerName, context);
    }

    @Override
    public void triggerProcessEvent(Integer processId, ProcessEvent processEvent) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForProcess(processId);
        context.setCurrentElement(this.getCurrentElement(context.getProcess(), processEvent));
        this.processEventNotifier.notify(processEvent, context);
    }

    @Override
    public void triggerTaskEvent(Integer taskId, TaskEvent taskEvent) {
        WorkflowContext context = this.workflowContextBuilder.buildContextForTask(taskId, WorkflowAction.fromTaskEvent(taskEvent));
        this.taskEventNotifier.notify(taskEvent, context);
    }

    private Element getCurrentElement(WorkflowProcess process, ProcessEvent processEvent) {
        if (ProcessEvent.CREATE.equals(processEvent)) {
            return process.getStartEvent();
        }
        return process.getEndEvent();
    }

    private ProcessEventListener getProcessEventListener(WorkflowProcess process, String listenerName) {
        return process.listener(listenerName);
    }

    private TaskEventListener getTaskEventListener(WorkflowTask task, String listenerName) {
        return task.listener(listenerName);
    }
}

