/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionRepository;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.springframework.stereotype.Component;

@Component
public class MemoryProcessDefinitionRepository
implements ProcessDefinitionRepository {
    private static final Map<String, WorkflowProcess> PROCESS_BY_NAME_MAP = Maps.newConcurrentMap();

    @Override
    public WorkflowProcess get(String name) {
        if (!PROCESS_BY_NAME_MAP.containsKey(name)) {
            return null;
        }
        try {
            return PROCESS_BY_NAME_MAP.get(name).clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new WorkflowException();
        }
    }

    @Override
    public void add(WorkflowProcess process) {
        Preconditions.checkNotEmpty((String)process.getName(), (String)"process name cannot be null");
        if (PROCESS_BY_NAME_MAP.containsKey(process.getName())) {
            throw new WorkflowException("process already exist with the same name " + process.getName());
        }
        PROCESS_BY_NAME_MAP.put(process.getName(), process);
    }

    @Override
    public void delete(String name) {
        if (!PROCESS_BY_NAME_MAP.containsKey(name)) {
            throw new WorkflowException("process definition not found for name " + name);
        }
        PROCESS_BY_NAME_MAP.remove(name);
    }
}

