/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.core.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.manager.common.enums.ProcessStatus;
import org.apache.inlong.manager.common.enums.TaskStatus;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.dao.entity.WorkflowTaskEntity;
import org.apache.inlong.manager.dao.mapper.WorkflowTaskEntityMapper;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.core.ProcessService;
import org.apache.inlong.manager.workflow.core.ProcessorExecutor;
import org.apache.inlong.manager.workflow.core.WorkflowContextBuilder;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessServiceImpl
implements ProcessService {
    private static final Logger log = LoggerFactory.getLogger(ProcessServiceImpl.class);
    @Autowired
    private ProcessorExecutor processorExecutor;
    @Autowired
    private WorkflowTaskEntityMapper taskEntityMapper;
    @Autowired
    private WorkflowContextBuilder workflowContextBuilder;

    @Override
    public WorkflowContext start(String name, String applicant, ProcessForm form) {
        Preconditions.checkNotEmpty((String)name, (String)"process name cannot be null");
        Preconditions.checkNotEmpty((String)applicant, (String)"applicant cannot be null");
        Preconditions.checkNotNull((Object)form, (String)"form cannot be null");
        WorkflowContext context = this.workflowContextBuilder.buildContextForProcess(name, applicant, form);
        this.processorExecutor.executeStart(context.getProcess().getStartEvent(), context);
        return context;
    }

    @Override
    public WorkflowContext continueProcess(Integer processId, String operator, String remark) {
        Preconditions.checkNotEmpty((String)operator, (String)"operator cannot be null");
        Preconditions.checkNotNull((Object)processId, (String)"processId cannot be null");
        WorkflowContext context = this.workflowContextBuilder.buildContextForProcess(processId);
        WorkflowProcessEntity processEntity = context.getProcessEntity();
        ProcessStatus processStatus = ProcessStatus.valueOf((String)processEntity.getStatus());
        Preconditions.checkTrue((processStatus == ProcessStatus.PROCESSING ? 1 : 0) != 0, (String)String.format("processId=%s should be in processing", processId));
        ArrayList startElements = Lists.newArrayList();
        startElements.addAll(this.taskEntityMapper.selectByProcess(processId, TaskStatus.PENDING));
        startElements.addAll(this.taskEntityMapper.selectByProcess(processId, TaskStatus.FAILED));
        for (WorkflowTaskEntity taskEntity : startElements) {
            String taskName = taskEntity.getName();
            WorkflowTask task = context.getProcess().getTaskByName(taskName);
            context.setActionContext(new WorkflowContext.ActionContext().setAction(WorkflowAction.COMPLETE).setTaskEntity(taskEntity).setOperator(operator).setRemark(remark).setTask(task));
            this.processorExecutor.executeStart(task, context);
        }
        return context;
    }

    @Override
    public WorkflowContext cancel(Integer processId, String operator, String remark) {
        Preconditions.checkNotEmpty((String)operator, (String)"operator cannot be null");
        Preconditions.checkNotNull((Object)processId, (String)"processId cannot be null");
        WorkflowContext context = this.workflowContextBuilder.buildContextForProcess(processId);
        List pendingTasks = this.taskEntityMapper.selectByProcess(processId, TaskStatus.PENDING);
        for (WorkflowTaskEntity taskEntity : pendingTasks) {
            WorkflowTask task = context.getProcess().getTaskByName(taskEntity.getName());
            context.setActionContext(new WorkflowContext.ActionContext().setAction(WorkflowAction.CANCEL).setTaskEntity(taskEntity).setOperator(operator).setRemark(remark).setTask(task));
            this.processorExecutor.executeComplete(task, context);
        }
        return context;
    }
}

