/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.event;

import java.util.Date;
import java.util.Optional;
import org.apache.inlong.manager.common.enums.EventStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.util.NetworkUtils;
import org.apache.inlong.manager.dao.entity.WorkflowEventLogEntity;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.dao.mapper.WorkflowEventLogEntityMapper;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.event.EventListener;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.WorkflowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogableEventListener<EventType extends WorkflowEvent>
implements EventListener<EventType> {
    private static final Logger log = LoggerFactory.getLogger(LogableEventListener.class);
    private final EventListener<EventType> eventListener;
    private final WorkflowEventLogEntityMapper eventLogMapper;

    public LogableEventListener(EventListener<EventType> eventListener, WorkflowEventLogEntityMapper eventLogMapper) {
        this.eventListener = eventListener;
        this.eventLogMapper = eventLogMapper;
    }

    @Override
    public EventType event() {
        return this.eventListener.event();
    }

    @Override
    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        if (this.eventListener.ignoreRecordLog()) {
            return this.executeListenerWithoutLog(context);
        }
        return this.executeListenerWithLog(context);
    }

    private ListenerResult executeListenerWithoutLog(WorkflowContext context) {
        WorkflowEventLogEntity workflowEventLogEntity = this.buildEventLog(context);
        try {
            ListenerResult result = this.eventListener.listen(context);
            log.debug("listener execute result: {} - {}", (Object)workflowEventLogEntity, (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error("execute listener " + workflowEventLogEntity + " error: ", (Throwable)e);
            return ListenerResult.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerResult executeListenerWithLog(WorkflowContext context) {
        ListenerResult result;
        WorkflowEventLogEntity logEntity = this.buildEventLog(context);
        try {
            result = this.eventListener.listen(context);
            logEntity.setStatus(Integer.valueOf(result.isSuccess() ? EventStatus.SUCCESS.getStatus() : EventStatus.FAILED.getStatus()));
            logEntity.setRemark(result.getRemark());
            logEntity.setException((String)Optional.ofNullable(result.getException()).map(Throwable::getMessage).orElse(null));
        }
        catch (Exception e) {
            logEntity.setStatus(Integer.valueOf(EventStatus.FAILED.getStatus()));
            logEntity.setException(e.getMessage());
            log.error("execute listener " + logEntity + " error: ", (Throwable)e);
            result = ListenerResult.fail(e);
        }
        finally {
            logEntity.setEndTime(new Date());
            this.eventLogMapper.insert(logEntity);
        }
        return result;
    }

    protected WorkflowEventLogEntity buildEventLog(WorkflowContext context) {
        WorkflowProcessEntity workflowProcessEntity = context.getProcessEntity();
        Element currentElement = context.getCurrentElement();
        WorkflowEventLogEntity logEntity = new WorkflowEventLogEntity();
        logEntity.setProcessId(workflowProcessEntity.getId());
        logEntity.setProcessName(workflowProcessEntity.getName());
        logEntity.setProcessDisplayName(workflowProcessEntity.getDisplayName());
        logEntity.setInlongGroupId(context.getProcessForm().getInlongGroupId());
        logEntity.setElementName(currentElement.getName());
        logEntity.setElementDisplayName(currentElement.getDisplayName());
        logEntity.setEventType(this.event().getClass().getSimpleName());
        logEntity.setEvent(this.event().name());
        logEntity.setListener(this.eventListener.name());
        logEntity.setStatus(Integer.valueOf(EventStatus.EXECUTING.getStatus()));
        logEntity.setAsync(Integer.valueOf(0));
        logEntity.setIp(NetworkUtils.getLocalIp());
        logEntity.setStartTime(new Date());
        return logEntity;
    }
}

