/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.event.process;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.manager.dao.mapper.WorkflowEventLogEntityMapper;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.event.EventListenerNotifier;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.LogableEventListener;
import org.apache.inlong.manager.workflow.event.process.LogableProcessEventListener;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessEventNotifier
implements EventListenerNotifier<ProcessEvent> {
    private static final Logger log = LoggerFactory.getLogger(ProcessEventNotifier.class);
    @Autowired
    private WorkflowEventLogEntityMapper eventLogMapper;

    @Override
    public ListenerResult notify(ProcessEvent event, WorkflowContext context) {
        WorkflowProcess process = context.getProcess();
        List logableListeners = process.listeners(event).stream().map(listener -> this.logableEventListener((ProcessEventListener)listener)).collect(Collectors.toList());
        for (LogableProcessEventListener listener2 : logableListeners) {
            ListenerResult result = listener2.listen(context);
            if (result.isSuccess()) continue;
            return result;
        }
        return ListenerResult.success();
    }

    @Override
    public ListenerResult notify(String listenerName, WorkflowContext sourceContext) {
        WorkflowProcess process = sourceContext.getProcess();
        ProcessEventListener listener = process.listener(listenerName);
        if (listener == null) {
            return ListenerResult.success();
        }
        return this.logableEventListener(listener).listen(sourceContext);
    }

    private LogableProcessEventListener logableEventListener(ProcessEventListener listener) {
        if (listener instanceof LogableEventListener) {
            return (LogableProcessEventListener)listener;
        }
        return new LogableProcessEventListener(listener, this.eventLogMapper);
    }
}

