/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.event.task;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.manager.dao.mapper.WorkflowEventLogEntityMapper;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.EventListenerNotifier;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.LogableEventListener;
import org.apache.inlong.manager.workflow.event.task.LogableTaskEventListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskEventNotifier
implements EventListenerNotifier<TaskEvent> {
    private static final Logger log = LoggerFactory.getLogger(TaskEventNotifier.class);
    @Autowired
    private WorkflowEventLogEntityMapper eventLogMapper;

    public TaskEventNotifier(WorkflowEventLogEntityMapper eventLogMapper) {
        this.eventLogMapper = eventLogMapper;
    }

    @Override
    public ListenerResult notify(TaskEvent event, WorkflowContext context) {
        WorkflowTask task = (WorkflowTask)context.getCurrentElement();
        List logableListeners = task.listeners(event).stream().map(listener -> this.logableEventListener((TaskEventListener)listener)).collect(Collectors.toList());
        for (LogableTaskEventListener listener2 : logableListeners) {
            ListenerResult result = listener2.listen(context);
            if (result.isSuccess()) continue;
            return result;
        }
        return ListenerResult.success();
    }

    @Override
    public ListenerResult notify(String listenerName, WorkflowContext context) {
        WorkflowTask task = (WorkflowTask)context.getCurrentElement();
        TaskEventListener listener = task.listener(listenerName);
        if (listener == null) {
            return ListenerResult.success();
        }
        return this.logableEventListener(listener).listen(context);
    }

    private LogableTaskEventListener logableEventListener(TaskEventListener listener) {
        if (listener instanceof LogableEventListener) {
            return (LogableTaskEventListener)listener;
        }
        return new LogableTaskEventListener(listener, this.eventLogMapper);
    }
}

