/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.processor;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.enums.ProcessStatus;
import org.apache.inlong.manager.common.enums.TaskStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.dao.mapper.WorkflowProcessEntityMapper;
import org.apache.inlong.manager.dao.mapper.WorkflowTaskEntityMapper;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventNotifier;
import org.apache.inlong.manager.workflow.processor.ElementProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EndEventProcessor
implements ElementProcessor<EndEvent> {
    private static final Logger log = LoggerFactory.getLogger(EndEventProcessor.class);
    @Autowired
    private ProcessEventNotifier processEventNotifier;
    @Autowired
    private WorkflowTaskEntityMapper taskEntityMapper;
    @Autowired
    private WorkflowProcessEntityMapper processEntityMapper;

    @Override
    public Class<EndEvent> watch() {
        return EndEvent.class;
    }

    @Override
    public boolean create(EndEvent element, WorkflowContext context) {
        return true;
    }

    @Override
    public boolean pendingForAction(WorkflowContext context) {
        return false;
    }

    @Override
    public boolean complete(WorkflowContext context) {
        WorkflowProcessEntity processEntity = context.getProcessEntity();
        List tasks = this.taskEntityMapper.selectByProcess(processEntity.getId(), TaskStatus.PENDING);
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            log.warn("have pending task, end event not execute");
            return true;
        }
        WorkflowContext.ActionContext actionContext = context.getActionContext();
        processEntity.setStatus(this.getProcessStatus(actionContext.getAction()).name());
        processEntity.setEndTime(new Date());
        this.processEntityMapper.update(processEntity);
        ListenerResult listenerResult = this.processEventNotifier.notify(this.mapToEvent(actionContext.getAction()), context);
        return listenerResult.isSuccess();
    }

    @Override
    public List<Element> next(EndEvent element, WorkflowContext context) {
        return Collections.emptyList();
    }

    private ProcessStatus getProcessStatus(WorkflowAction workflowAction) {
        switch (workflowAction) {
            case APPROVE: 
            case COMPLETE: {
                return ProcessStatus.COMPLETED;
            }
            case REJECT: {
                return ProcessStatus.REJECTED;
            }
            case CANCEL: {
                return ProcessStatus.CANCELED;
            }
            case TERMINATE: {
                return ProcessStatus.TERMINATED;
            }
        }
        throw new WorkflowException("unknown workflowAction " + (Object)((Object)workflowAction));
    }

    private ProcessEvent mapToEvent(WorkflowAction workflowAction) {
        switch (workflowAction) {
            case APPROVE: 
            case COMPLETE: {
                return ProcessEvent.COMPLETE;
            }
            case REJECT: {
                return ProcessEvent.REJECT;
            }
            case CANCEL: {
                return ProcessEvent.CANCEL;
            }
            case TERMINATE: {
                return ProcessEvent.TERMINATE;
            }
        }
        throw new WorkflowException("unknown workflowAction " + (Object)((Object)workflowAction));
    }
}

