/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.TaskStatus;
import org.apache.inlong.manager.common.exceptions.JsonException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.dao.entity.WorkflowTaskEntity;
import org.apache.inlong.manager.dao.mapper.WorkflowTaskEntityMapper;
import org.apache.inlong.manager.pojo.workflow.TaskRequest;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.ServiceTaskForm;
import org.apache.inlong.manager.pojo.workflow.form.task.TaskForm;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.ApproverAssign;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventNotifier;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.event.task.TaskEventNotifier;
import org.apache.inlong.manager.workflow.processor.AbstractTaskProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceTaskProcessor
extends AbstractTaskProcessor<ServiceTask> {
    private static final Logger log = LoggerFactory.getLogger(ServiceTaskProcessor.class);
    private static final Set<TaskStatus> ALLOW_COMPLETE_STATE = ImmutableSet.of((Object)TaskStatus.PENDING, (Object)TaskStatus.FAILED);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private WorkflowTaskEntityMapper taskEntityMapper;
    @Autowired
    private TaskEventNotifier taskEventNotifier;
    @Autowired
    private ProcessEventNotifier processEventNotifier;

    @Override
    public Class<ServiceTask> watch() {
        return ServiceTask.class;
    }

    @Override
    public boolean create(ServiceTask serviceTask, WorkflowContext context) {
        context.setCurrentElement(serviceTask);
        WorkflowTaskEntity workflowTaskEntity = this.resetActionContext(context);
        try {
            serviceTask.initListeners(context);
            ListenerResult listenerResult = this.taskEventNotifier.notify(TaskEvent.CREATE, context);
            if (!listenerResult.isSuccess()) {
                this.failedTask(context, workflowTaskEntity);
            }
            return listenerResult.isSuccess();
        }
        catch (Exception e) {
            log.error("Create service task failed", (Throwable)e);
            this.failedTask(context, workflowTaskEntity);
            return false;
        }
    }

    @Override
    public boolean pendingForAction(WorkflowContext context) {
        return false;
    }

    @Override
    public boolean complete(WorkflowContext context) {
        WorkflowContext.ActionContext actionContext = context.getActionContext();
        if (actionContext == null) {
            this.resetActionContext(context);
        }
        WorkflowTaskEntity workflowTaskEntity = actionContext.getTaskEntity();
        Preconditions.checkTrue((boolean)ALLOW_COMPLETE_STATE.contains(TaskStatus.valueOf((String)workflowTaskEntity.getStatus())), (String)"task status should allow complete");
        try {
            ListenerResult listenerResult = this.taskEventNotifier.notify(TaskEvent.COMPLETE, context);
            if (!listenerResult.isSuccess()) {
                this.failedTask(context, workflowTaskEntity);
            } else {
                this.completeTaskEntity(context, workflowTaskEntity, TaskStatus.COMPLETED);
            }
            return listenerResult.isSuccess();
        }
        catch (Exception e) {
            log.error("Complete service task failed", (Throwable)e);
            this.failedTask(context, workflowTaskEntity);
            return false;
        }
    }

    private void failedTask(WorkflowContext context, WorkflowTaskEntity workflowTaskEntity) {
        this.completeTaskEntity(context, workflowTaskEntity, TaskStatus.FAILED);
        this.taskEventNotifier.notify(TaskEvent.FAIL, context);
        this.processEventNotifier.notify(ProcessEvent.FAIL, context);
    }

    private WorkflowTaskEntity resetActionContext(WorkflowContext context) {
        WorkflowProcessEntity processEntity = context.getProcessEntity();
        ServiceTask serviceTask = (ServiceTask)context.getCurrentElement();
        int processId = processEntity.getId();
        String serviceName = serviceTask.getName();
        TaskRequest taskQuery = new TaskRequest();
        taskQuery.setProcessId(Integer.valueOf(processId));
        taskQuery.setName(serviceName);
        List taskEntities = this.taskEntityMapper.selectByQuery(taskQuery);
        WorkflowTaskEntity taskEntity = CollectionUtils.isEmpty((Collection)taskEntities) ? this.saveTaskEntity(serviceTask, context) : (WorkflowTaskEntity)taskEntities.get(0);
        WorkflowContext.ActionContext actionContext = new WorkflowContext.ActionContext().setTask((WorkflowTask)context.getCurrentElement()).setAction(WorkflowAction.COMPLETE).setTaskEntity(taskEntity);
        context.setActionContext(actionContext);
        return taskEntity;
    }

    private WorkflowTaskEntity saveTaskEntity(ServiceTask serviceTask, WorkflowContext context) {
        WorkflowProcessEntity workflowProcessEntity = context.getProcessEntity();
        List<String> approvers = ApproverAssign.DEFAULT_SYSTEM_APPROVER.assign(context);
        WorkflowTaskEntity taskEntity = new WorkflowTaskEntity();
        taskEntity.setType(ServiceTask.class.getSimpleName());
        taskEntity.setProcessId(workflowProcessEntity.getId());
        taskEntity.setProcessName(context.getProcess().getName());
        taskEntity.setProcessDisplayName(context.getProcess().getDisplayName());
        taskEntity.setName(serviceTask.getName());
        taskEntity.setDisplayName(serviceTask.getDisplayName());
        taskEntity.setApplicant(workflowProcessEntity.getApplicant());
        taskEntity.setApprovers(StringUtils.join(approvers, (String)","));
        taskEntity.setStatus(TaskStatus.PENDING.name());
        taskEntity.setStartTime(new Date());
        this.taskEntityMapper.insert(taskEntity);
        Preconditions.checkNotNull((Object)taskEntity.getId(), (String)"task saved failed");
        return taskEntity;
    }

    private void completeTaskEntity(WorkflowContext context, WorkflowTaskEntity taskEntity, TaskStatus taskStatus) {
        WorkflowContext.ActionContext actionContext = context.getActionContext();
        taskEntity.setStatus(taskStatus.name());
        taskEntity.setOperator(taskEntity.getApprovers());
        taskEntity.setRemark(actionContext.getRemark());
        try {
            if (actionContext.getForm() == null) {
                ServiceTaskForm serviceTaskForm = new ServiceTaskForm();
                ProcessForm form = context.getProcessForm();
                serviceTaskForm.setInlongGroupId(form.getInlongGroupId());
                if (form instanceof StreamResourceProcessForm) {
                    String streamId = ((StreamResourceProcessForm)form).getStreamInfo().getInlongStreamId();
                    serviceTaskForm.setInlongStreamId(streamId);
                }
                actionContext.setForm((TaskForm)serviceTaskForm);
            }
            taskEntity.setFormData(this.objectMapper.writeValueAsString((Object)actionContext.getForm()));
        }
        catch (Exception e) {
            throw new JsonException("write form to json error: ", (Throwable)e);
        }
        taskEntity.setEndTime(new Date());
        this.taskEntityMapper.update(taskEntity);
    }
}

