/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import org.apache.inlong.manager.common.enums.ProcessStatus;
import org.apache.inlong.manager.common.exceptions.JsonException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.dao.mapper.WorkflowProcessEntityMapper;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventNotifier;
import org.apache.inlong.manager.workflow.processor.AbstractNextableElementProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StartEventProcessor
extends AbstractNextableElementProcessor<StartEvent> {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ProcessEventNotifier processEventNotifier;
    @Autowired
    private WorkflowProcessEntityMapper processEntityMapper;

    @Override
    public Class<StartEvent> watch() {
        return StartEvent.class;
    }

    @Override
    public boolean create(StartEvent startEvent, WorkflowContext context) {
        String applicant = context.getOperator();
        WorkflowProcess process = context.getProcess();
        ProcessForm form = context.getProcessForm();
        if (process.getFormClass() != null) {
            Preconditions.checkNotNull((Object)form, (String)"form cannot be null");
            Preconditions.checkTrue((boolean)form.getClass().isAssignableFrom(process.getFormClass()), (String)("form type not match, should be class " + process.getFormClass()));
            form.validate();
        } else {
            Preconditions.checkNull((Object)form, (String)"no form required");
        }
        WorkflowProcessEntity processEntity = this.saveProcessEntity(applicant, process, form);
        context.setProcessEntity(processEntity);
        context.setActionContext(new WorkflowContext.ActionContext().setAction(WorkflowAction.START));
        return true;
    }

    @Override
    public boolean pendingForAction(WorkflowContext context) {
        return false;
    }

    @Override
    public boolean complete(WorkflowContext context) {
        ListenerResult listenerResult = this.processEventNotifier.notify(ProcessEvent.CREATE, context);
        return listenerResult.isSuccess();
    }

    private WorkflowProcessEntity saveProcessEntity(String applicant, WorkflowProcess process, ProcessForm form) {
        WorkflowProcessEntity processEntity = new WorkflowProcessEntity();
        processEntity.setName(process.getName());
        processEntity.setDisplayName(process.getDisplayName());
        processEntity.setType(process.getType());
        processEntity.setTitle(form.getTitle());
        processEntity.setInlongGroupId(form.getInlongGroupId());
        processEntity.setApplicant(applicant);
        processEntity.setStatus(ProcessStatus.PROCESSING.name());
        try {
            processEntity.setFormData(this.objectMapper.writeValueAsString((Object)form));
        }
        catch (Exception e) {
            throw new JsonException("write form to json error: ", (Throwable)e);
        }
        processEntity.setStartTime(new Date());
        processEntity.setHidden(process.getHidden());
        this.processEntityMapper.insert(processEntity);
        Preconditions.checkNotNull((Object)processEntity.getId(), (String)"process saved failed");
        return processEntity;
    }
}

