/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.processor;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.NextableElement;
import org.apache.inlong.manager.workflow.processor.ElementProcessor;
import org.springframework.util.CollectionUtils;

public abstract class AbstractNextableElementProcessor<T extends NextableElement>
implements ElementProcessor<T> {
    @Override
    public List<Element> next(T element, WorkflowContext context) {
        WorkflowContext.ActionContext actionContext = context.getActionContext();
        List<Element> nextElements = ((NextableElement)element).getNextList(actionContext.getAction(), context);
        Preconditions.checkNotEmpty(nextElements, (String)"not found next element ");
        Element endEvent = nextElements.stream().filter(EndEvent.class::isInstance).findFirst().orElse(null);
        if (endEvent == null) {
            return nextElements;
        }
        List notEndEventElements = nextElements.stream().filter(ele -> !(ele instanceof EndEvent)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(notEndEventElements)) {
            return Collections.singletonList(endEvent);
        }
        throw new WorkflowException("process definition error, find endEvent and not endEvent at the same time");
    }
}

