/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.enums.TaskStatus;
import org.apache.inlong.manager.common.exceptions.JsonException;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.dao.entity.WorkflowTaskEntity;
import org.apache.inlong.manager.pojo.workflow.form.task.TaskForm;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.TaskEventNotifier;
import org.apache.inlong.manager.workflow.processor.AbstractTaskProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserTaskProcessor
extends AbstractTaskProcessor<UserTask> {
    private static final Logger log = LoggerFactory.getLogger(UserTaskProcessor.class);
    private static final Set<WorkflowAction> SHOULD_CHECK_OPERATOR_ACTIONS = ImmutableSet.of((Object)((Object)WorkflowAction.APPROVE), (Object)((Object)WorkflowAction.REJECT), (Object)((Object)WorkflowAction.TRANSFER));
    private static final Set<WorkflowAction> SUPPORT_ACTIONS = ImmutableSet.of((Object)((Object)WorkflowAction.APPROVE), (Object)((Object)WorkflowAction.REJECT), (Object)((Object)WorkflowAction.TRANSFER), (Object)((Object)WorkflowAction.CANCEL), (Object)((Object)WorkflowAction.TERMINATE));
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private TaskEventNotifier taskEventNotifier;

    @Override
    public Class<UserTask> watch() {
        return UserTask.class;
    }

    @Override
    public boolean create(UserTask userTask, WorkflowContext context) {
        List<String> approvers = userTask.getApproverAssign().assign(context);
        Preconditions.checkNotEmpty(approvers, (String)("Cannot assign approvers for task: " + userTask.getDisplayName() + ", as the approvers was empty"));
        if (!userTask.isNeedAllApprove()) {
            approvers = Collections.singletonList(StringUtils.join(approvers, (String)","));
        }
        WorkflowProcessEntity processEntity = context.getProcessEntity();
        List<WorkflowTaskEntity> userTaskEntities = approvers.stream().map(approver -> this.saveTaskEntity(userTask, processEntity, (String)approver)).collect(Collectors.toList());
        this.resetActionContext(context, userTaskEntities);
        ListenerResult listenerResult = this.taskEventNotifier.notify(TaskEvent.CREATE, context);
        return listenerResult.isSuccess();
    }

    @Override
    public boolean pendingForAction(WorkflowContext context) {
        return true;
    }

    @Override
    public boolean complete(WorkflowContext context) {
        WorkflowContext.ActionContext actionContext = context.getActionContext();
        Preconditions.checkTrue((boolean)SUPPORT_ACTIONS.contains((Object)actionContext.getAction()), (String)("UserTask not support action:" + (Object)((Object)actionContext.getAction())));
        WorkflowTaskEntity workflowTaskEntity = actionContext.getTaskEntity();
        Preconditions.checkTrue((boolean)TaskStatus.PENDING.name().equalsIgnoreCase(workflowTaskEntity.getStatus()), (String)"task status should be pending");
        this.checkOperator(actionContext);
        this.completeTaskInstance(actionContext);
        ListenerResult listenerResult = this.taskEventNotifier.notify(this.toTaskEvent(actionContext.getAction()), context);
        return listenerResult.isSuccess();
    }

    @Override
    public List<Element> next(UserTask userTask, WorkflowContext context) {
        WorkflowTaskEntity workflowTaskEntity;
        int pendingCount;
        WorkflowContext.ActionContext actionContext = context.getActionContext();
        if (userTask.isNeedAllApprove() && (pendingCount = this.taskEntityMapper.countByStatus((workflowTaskEntity = actionContext.getTaskEntity()).getProcessId(), workflowTaskEntity.getName(), TaskStatus.PENDING)) > 0) {
            return Lists.newArrayList();
        }
        return super.next(userTask, context);
    }

    private void resetActionContext(WorkflowContext context, List<WorkflowTaskEntity> userTaskEntities) {
        WorkflowContext.ActionContext actionContext = new WorkflowContext.ActionContext().setTask((WorkflowTask)context.getCurrentElement()).setAction(WorkflowAction.COMPLETE).setTaskEntity(userTaskEntities.get(0));
        context.setActionContext(actionContext);
    }

    private WorkflowTaskEntity saveTaskEntity(UserTask task, WorkflowProcessEntity processEntity, String approvers) {
        WorkflowTaskEntity taskEntity = new WorkflowTaskEntity();
        taskEntity.setType(UserTask.class.getSimpleName());
        taskEntity.setProcessId(processEntity.getId());
        taskEntity.setProcessName(processEntity.getName());
        taskEntity.setProcessDisplayName(processEntity.getDisplayName());
        taskEntity.setApplicant(processEntity.getApplicant());
        taskEntity.setName(task.getName());
        taskEntity.setDisplayName(task.getDisplayName());
        taskEntity.setApprovers(approvers);
        taskEntity.setStatus(TaskStatus.PENDING.name());
        taskEntity.setStartTime(new Date());
        this.taskEntityMapper.insert(taskEntity);
        Preconditions.checkNotNull((Object)taskEntity.getId(), (String)"task saved failed");
        return taskEntity;
    }

    private void checkOperator(WorkflowContext.ActionContext actionContext) {
        WorkflowTaskEntity workflowTaskEntity = actionContext.getTaskEntity();
        if (!SHOULD_CHECK_OPERATOR_ACTIONS.contains((Object)actionContext.getAction())) {
            return;
        }
        boolean operatorIsApprover = ArrayUtils.contains((Object[])workflowTaskEntity.getApprovers().split(","), (Object)actionContext.getOperator());
        if (!operatorIsApprover) {
            throw new WorkflowException(String.format("current operator %s not in approvers list: %s", actionContext.getOperator(), workflowTaskEntity.getApprovers()));
        }
    }

    private void completeTaskInstance(WorkflowContext.ActionContext actionContext) {
        WorkflowTaskEntity taskEntity = actionContext.getTaskEntity();
        TaskStatus taskStatus = this.toTaskState(actionContext.getAction());
        taskEntity.setStatus(taskStatus.name());
        taskEntity.setOperator(actionContext.getOperator());
        taskEntity.setRemark(actionContext.getRemark());
        UserTask userTask = (UserTask)actionContext.getTask();
        try {
            TaskForm taskForm = actionContext.getForm();
            if (this.needForm(userTask, actionContext.getAction())) {
                Preconditions.checkNotNull((Object)taskForm, (String)"form cannot be null");
                Preconditions.checkTrue((boolean)taskForm.getClass().isAssignableFrom(userTask.getFormClass()), (String)("form type not match, should be class " + userTask.getFormClass()));
                taskForm.validate();
                taskEntity.setFormData(this.objectMapper.writeValueAsString((Object)taskForm));
            } else {
                Preconditions.checkNull((Object)taskForm, (String)"no form required");
            }
            taskEntity.setEndTime(new Date());
            Map<String, List<String>> extMap = new HashMap();
            if (StringUtils.isNotBlank((CharSequence)taskEntity.getExtParams())) {
                extMap = (Map)this.objectMapper.readValue(taskEntity.getExtParams(), (JavaType)this.objectMapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class));
                if (WorkflowAction.TRANSFER.equals((Object)actionContext.getAction())) {
                    extMap.put("transferToUsers", actionContext.getTransferToUsers());
                }
            }
            String extParams = this.objectMapper.writeValueAsString(extMap);
            taskEntity.setExtParams(extParams);
        }
        catch (JsonProcessingException e) {
            log.error("parse transfer users error: ", (Throwable)e);
            throw new JsonException("parse transfer users error");
        }
        this.taskEntityMapper.update(taskEntity);
    }

    private boolean needForm(UserTask userTask, WorkflowAction workflowAction) {
        if (userTask.getFormClass() == null) {
            return false;
        }
        return WorkflowAction.APPROVE.equals((Object)workflowAction) || WorkflowAction.COMPLETE.equals((Object)workflowAction);
    }

    private TaskStatus toTaskState(WorkflowAction workflowAction) {
        switch (workflowAction) {
            case APPROVE: {
                return TaskStatus.APPROVED;
            }
            case REJECT: {
                return TaskStatus.REJECTED;
            }
            case CANCEL: {
                return TaskStatus.CANCELED;
            }
            case TRANSFER: {
                return TaskStatus.TRANSFERRED;
            }
            case TERMINATE: {
                return TaskStatus.TERMINATED;
            }
        }
        throw new WorkflowException("unknown workflowAction " + this);
    }

    private TaskEvent toTaskEvent(WorkflowAction workflowAction) {
        switch (workflowAction) {
            case APPROVE: {
                return TaskEvent.APPROVE;
            }
            case REJECT: {
                return TaskEvent.REJECT;
            }
            case CANCEL: {
                return TaskEvent.CANCEL;
            }
            case TRANSFER: {
                return TaskEvent.TRANSFER;
            }
            case TERMINATE: {
                return TaskEvent.TERMINATE;
            }
        }
        throw new WorkflowException("unknown workflow action " + this);
    }
}

