/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ProcessStatus;
import org.apache.inlong.manager.common.enums.TaskStatus;
import org.apache.inlong.manager.common.exceptions.FormParseException;
import org.apache.inlong.manager.common.exceptions.JsonException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowEventLogEntity;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.dao.entity.WorkflowTaskEntity;
import org.apache.inlong.manager.pojo.workflow.ListenerExecuteLog;
import org.apache.inlong.manager.pojo.workflow.ProcessResponse;
import org.apache.inlong.manager.pojo.workflow.TaskExecuteLog;
import org.apache.inlong.manager.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.TaskForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowUtils.class);

    public static WorkflowContext buildContext(ObjectMapper objectMapper, WorkflowProcess process, WorkflowProcessEntity processEntity) {
        try {
            Object form = WorkflowUtils.parseProcessForm(objectMapper, processEntity.getFormData(), process);
            return new WorkflowContext().setProcess(process).setOperator(processEntity.getApplicant()).setProcessForm((ProcessForm)form).setProcessEntity(processEntity);
        }
        catch (Exception e) {
            LOGGER.error("build context from process form failed with id=" + processEntity.getId(), (Throwable)e);
            return null;
        }
    }

    public static WorkflowResult getResult(WorkflowContext context) {
        if (context == null) {
            return null;
        }
        WorkflowResult workflowResult = new WorkflowResult();
        workflowResult.setProcessInfo(WorkflowUtils.getProcessResponse(context.getProcessEntity()));
        if (context.getActionContext() != null) {
            WorkflowContext.ActionContext newAction = context.getActionContext();
            workflowResult.setNewTasks((List)Lists.newArrayList((Object[])new TaskResponse[]{WorkflowUtils.getTaskResponse(newAction.getTaskEntity())}));
        }
        return workflowResult;
    }

    public static ProcessResponse getProcessResponse(WorkflowProcessEntity entity) {
        if (entity == null) {
            return null;
        }
        ProcessResponse processResponse = ProcessResponse.builder().id(entity.getId()).name(entity.getName()).displayName(entity.getDisplayName()).type(entity.getType()).title(entity.getTitle()).applicant(entity.getApplicant()).status(ProcessStatus.valueOf((String)entity.getStatus())).startTime(entity.getStartTime()).endTime(entity.getEndTime()).build();
        try {
            if (StringUtils.isNotBlank((CharSequence)entity.getFormData())) {
                processResponse.setFormData((Object)JsonUtils.parseTree((String)entity.getFormData()));
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
                processResponse.setExtParams((Object)JsonUtils.parseTree((String)entity.getExtParams()));
            }
        }
        catch (Exception e) {
            LOGGER.error("parse process form error: ", (Throwable)e);
            throw new JsonException("parse process form or ext params error, please contact administrator");
        }
        return processResponse;
    }

    public static TaskResponse getTaskResponse(WorkflowTaskEntity taskEntity) {
        if (taskEntity == null) {
            return null;
        }
        TaskResponse taskResponse = TaskResponse.builder().id(taskEntity.getId()).type(taskEntity.getType()).processId(taskEntity.getProcessId()).processName(taskEntity.getProcessName()).processDisplayName(taskEntity.getProcessDisplayName()).name(taskEntity.getName()).displayName(taskEntity.getDisplayName()).applicant(taskEntity.getApplicant()).approvers(Arrays.asList(taskEntity.getApprovers().split(","))).operator(taskEntity.getOperator()).status(TaskStatus.valueOf((String)taskEntity.getStatus())).remark(taskEntity.getRemark()).startTime(taskEntity.getStartTime()).endTime(taskEntity.getEndTime()).build();
        try {
            JsonNode formData = null;
            if (StringUtils.isNotBlank((CharSequence)taskEntity.getFormData())) {
                formData = JsonUtils.parseTree((String)taskEntity.getFormData());
            }
            taskResponse.setFormData(formData);
        }
        catch (Exception e) {
            LOGGER.error("parse task form error: ", (Throwable)e);
            throw new JsonException("parse task form or ext params error, please contact administrator");
        }
        return taskResponse;
    }

    public static <T extends ProcessForm> T parseProcessForm(ObjectMapper objectMapper, String form, WorkflowProcess process) {
        Preconditions.checkNotNull((Object)process, (String)"process cannot be null");
        if (StringUtils.isEmpty((CharSequence)form)) {
            return null;
        }
        try {
            JavaType javaType = objectMapper.constructType(process.getFormClass());
            return (T)((ProcessForm)objectMapper.readValue(form, javaType));
        }
        catch (Exception e) {
            LOGGER.error("parse process form failed for {}", (Object)form, (Object)e);
            throw new FormParseException("parse process form failed, please contact administrator");
        }
    }

    public static <T extends TaskForm> T parseTaskForm(ObjectMapper objectMapper, WorkflowTaskEntity taskEntity, WorkflowProcess process) {
        Preconditions.checkNotNull((Object)taskEntity, (String)"taskEntity cannot be null");
        Preconditions.checkNotNull((Object)process, (String)"process cannot be null");
        if (StringUtils.isEmpty((CharSequence)taskEntity.getFormData())) {
            return null;
        }
        WorkflowTask task = process.getTaskByName(taskEntity.getName());
        Preconditions.checkNotNull((Object)task, (String)("user task not exist " + taskEntity.getName()));
        Preconditions.checkTrue((boolean)(task instanceof UserTask), (String)("task should be userTask " + taskEntity.getName()));
        UserTask userTask = (UserTask)task;
        try {
            JavaType javaType = objectMapper.constructType(userTask.getFormClass());
            return (T)((TaskForm)objectMapper.readValue(taskEntity.getFormData(), javaType));
        }
        catch (Exception e) {
            LOGGER.error("parse task form failed for {}", (Object)taskEntity.getFormData(), (Object)e);
            throw new FormParseException("parse task form failed, please contact the administrator");
        }
    }

    public static TaskExecuteLog getTaskExecuteLog(WorkflowTaskEntity taskEntity) {
        return TaskExecuteLog.builder().taskType(taskEntity.getType()).taskId(taskEntity.getId()).taskDisplayName(taskEntity.getDisplayName()).status(taskEntity.getStatus()).startTime(taskEntity.getStartTime()).endTime(taskEntity.getEndTime()).build();
    }

    public static ListenerExecuteLog getListenerExecuteLog(WorkflowEventLogEntity eventLogEntity) {
        ListenerExecuteLog executorLog = ListenerExecuteLog.builder().id(eventLogEntity.getId()).eventType(eventLogEntity.getEventType()).event(eventLogEntity.getEvent()).listener(eventLogEntity.getListener()).status(eventLogEntity.getStatus()).async(eventLogEntity.getAsync()).ip(eventLogEntity.getIp()).startTime(eventLogEntity.getStartTime()).endTime(eventLogEntity.getEndTime()).remark(eventLogEntity.getRemark()).exception(eventLogEntity.getException()).build();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String desc = sdf.format(executorLog.getStartTime()) + " ~ " + sdf.format(executorLog.getEndTime()) + " [" + executorLog.getListener() + "] event: [" + executorLog.getEvent() + "], executed [" + (executorLog.getStatus() == 1 ? "success" : "failed") + "], remark: [" + executorLog.getRemark() + "], exception: [" + executorLog.getException() + "]";
        executorLog.setDescription(desc);
        return executorLog;
    }
}

