/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.definition;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.workflow.form.task.TaskForm;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.ApproverAssign;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;

public class UserTask
extends WorkflowTask {
    private static final Set<WorkflowAction> SUPPORTED_ACTIONS = ImmutableSet.of((Object)((Object)WorkflowAction.APPROVE), (Object)((Object)WorkflowAction.REJECT), (Object)((Object)WorkflowAction.TRANSFER), (Object)((Object)WorkflowAction.TERMINATE), (Object)((Object)WorkflowAction.CANCEL));
    private ApproverAssign approverAssign;
    private Class<? extends TaskForm> formClass;

    @Override
    public WorkflowAction defaultNextAction() {
        return WorkflowAction.APPROVE;
    }

    @Override
    protected Set<WorkflowAction> supportedActions() {
        return SUPPORTED_ACTIONS;
    }

    @Override
    public List<Element> getNextList(WorkflowAction action, WorkflowContext context) {
        Preconditions.checkTrue((boolean)this.supportedActions().contains((Object)action), (String)("not support workflow action " + (Object)((Object)action) + ", it should in one of " + this.supportedActions()));
        switch (action) {
            case APPROVE: {
                return super.getNextList(action, context);
            }
            case REJECT: 
            case CANCEL: 
            case TERMINATE: {
                return Collections.singletonList(context.getProcess().getEndEvent());
            }
            case TRANSFER: {
                List<String> transferToUsers = context.getActionContext().getTransferToUsers();
                this.setApproverAssign(c -> transferToUsers);
                return Collections.singletonList(this);
            }
        }
        throw new WorkflowException("unknown workflow action: " + (Object)((Object)action));
    }

    @Override
    public UserTask clone() {
        UserTask userTask = (UserTask)super.clone();
        userTask.setApproverAssign(this.approverAssign);
        userTask.setFormClass(this.formClass);
        return userTask;
    }

    public ApproverAssign getApproverAssign() {
        return this.approverAssign;
    }

    public Class<? extends TaskForm> getFormClass() {
        return this.formClass;
    }

    public void setApproverAssign(ApproverAssign approverAssign) {
        this.approverAssign = approverAssign;
    }

    public void setFormClass(Class<? extends TaskForm> formClass) {
        this.formClass = formClass;
    }

    @Override
    public String toString() {
        return "UserTask(approverAssign=" + this.getApproverAssign() + ", formClass=" + this.getFormClass() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserTask)) {
            return false;
        }
        UserTask other = (UserTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApproverAssign this$approverAssign = this.getApproverAssign();
        ApproverAssign other$approverAssign = other.getApproverAssign();
        if (this$approverAssign == null ? other$approverAssign != null : !this$approverAssign.equals(other$approverAssign)) {
            return false;
        }
        Class<? extends TaskForm> this$formClass = this.getFormClass();
        Class<? extends TaskForm> other$formClass = other.getFormClass();
        return !(this$formClass == null ? other$formClass != null : !this$formClass.equals(other$formClass));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserTask;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ApproverAssign $approverAssign = this.getApproverAssign();
        result = result * 59 + ($approverAssign == null ? 43 : $approverAssign.hashCode());
        Class<? extends TaskForm> $formClass = this.getFormClass();
        result = result * 59 + ($formClass == null ? 43 : $formClass.hashCode());
        return result;
    }
}

