/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow.definition;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import org.apache.commons.collections.MapUtils;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.workflow.WorkflowAction;
import org.apache.inlong.manager.workflow.definition.ConditionNextElement;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.NextableElement;
import org.apache.inlong.manager.workflow.definition.ProcessDetailHandler;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;

public class WorkflowProcess
extends Element {
    private String type;
    private StartEvent startEvent;
    private EndEvent endEvent;
    private Map<String, WorkflowTask> nameToTaskMap = Maps.newHashMap();
    private Class<? extends ProcessForm> formClass;
    private ProcessDetailHandler processDetailHandler;
    private Integer hidden = 0;
    private Map<ProcessEvent, List<ProcessEventListener>> listeners = Maps.newHashMap();
    private Map<String, ProcessEventListener> nameToListenerMap = Maps.newHashMap();
    private int version;

    public WorkflowProcess addListener(ProcessEventListener listener) {
        if (this.nameToListenerMap.containsKey(listener.name())) {
            throw new WorkflowListenerException("duplicate listener:" + listener.name());
        }
        this.nameToListenerMap.put(listener.name(), listener);
        this.listeners.computeIfAbsent((ProcessEvent)listener.event(), (Function<ProcessEvent, List<ProcessEventListener>>)((Function<ProcessEvent, List>)a -> Lists.newArrayList())).add(listener);
        return this;
    }

    public List<ProcessEventListener> listeners(ProcessEvent processEvent) {
        return this.listeners.getOrDefault(processEvent, ProcessEventListener.EMPTY_LIST);
    }

    public ProcessEventListener listener(String listenerName) {
        return this.nameToListenerMap.get(listenerName);
    }

    public WorkflowProcess addTask(WorkflowTask task) {
        if (this.nameToTaskMap.containsKey(task.getName())) {
            throw new WorkflowException("task name cannot duplicate " + task.getName());
        }
        this.nameToTaskMap.put(task.getName(), task);
        return this;
    }

    public WorkflowTask getTaskByName(String name) {
        if (!this.nameToTaskMap.containsKey(name)) {
            throw new WorkflowException("cannot find task with the name " + name);
        }
        return this.nameToTaskMap.get(name);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkNotEmpty((String)this.type, (String)"process type cannot be empty");
        Preconditions.checkNotNull((Object)this.startEvent, (String)"start event cannot be null");
        Preconditions.checkNotNull((Object)this.endEvent, (String)"end event cannot be null");
        this.startEvent.validate();
        this.endEvent.validate();
        this.nameToTaskMap.values().forEach(NextableElement::validate);
    }

    @Override
    public WorkflowProcess clone() throws CloneNotSupportedException {
        WorkflowProcess cloneProcess = (WorkflowProcess)super.clone();
        cloneProcess.setStartEvent((StartEvent)this.startEvent.clone());
        cloneProcess.setEndEvent((EndEvent)this.endEvent.clone());
        HashMap<String, WorkflowTask> nameToTaskMap = new HashMap<String, WorkflowTask>();
        StartEvent startEvent = cloneProcess.getStartEvent();
        Map workflowActionListMap = startEvent.getActionToNextElementMap();
        LinkedBlockingQueue<Map<WorkflowAction, List<ConditionNextElement>>> queue = new LinkedBlockingQueue<Map<WorkflowAction, List<ConditionNextElement>>>();
        if (MapUtils.isNotEmpty(workflowActionListMap)) {
            queue.add(workflowActionListMap);
        }
        while (!queue.isEmpty()) {
            workflowActionListMap = (Map)queue.remove();
            for (List conditionNextElements : workflowActionListMap.values()) {
                for (ConditionNextElement conditionNextElement : conditionNextElements) {
                    NextableElement nextableElement;
                    Map<WorkflowAction, List<ConditionNextElement>> childListMap;
                    Element element = conditionNextElement.getElement();
                    if (element instanceof WorkflowTask) {
                        WorkflowTask workflowTask = (WorkflowTask)element;
                        nameToTaskMap.put(workflowTask.getName(), workflowTask);
                    }
                    if (!(element instanceof NextableElement) || !MapUtils.isNotEmpty(childListMap = (nextableElement = (NextableElement)element).getActionToNextElementMap())) continue;
                    queue.add(childListMap);
                }
            }
        }
        cloneProcess.setNameToTaskMap(nameToTaskMap);
        HashMap cloneListeners = Maps.newHashMap();
        cloneListeners.putAll(this.listeners);
        cloneProcess.listeners = cloneListeners;
        return cloneProcess;
    }

    public String getType() {
        return this.type;
    }

    public StartEvent getStartEvent() {
        return this.startEvent;
    }

    public EndEvent getEndEvent() {
        return this.endEvent;
    }

    public Class<? extends ProcessForm> getFormClass() {
        return this.formClass;
    }

    public ProcessDetailHandler getProcessDetailHandler() {
        return this.processDetailHandler;
    }

    public Integer getHidden() {
        return this.hidden;
    }

    public Map<ProcessEvent, List<ProcessEventListener>> getListeners() {
        return this.listeners;
    }

    public Map<String, ProcessEventListener> getNameToListenerMap() {
        return this.nameToListenerMap;
    }

    public int getVersion() {
        return this.version;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStartEvent(StartEvent startEvent) {
        this.startEvent = startEvent;
    }

    public void setEndEvent(EndEvent endEvent) {
        this.endEvent = endEvent;
    }

    public void setNameToTaskMap(Map<String, WorkflowTask> nameToTaskMap) {
        this.nameToTaskMap = nameToTaskMap;
    }

    public void setFormClass(Class<? extends ProcessForm> formClass) {
        this.formClass = formClass;
    }

    public void setProcessDetailHandler(ProcessDetailHandler processDetailHandler) {
        this.processDetailHandler = processDetailHandler;
    }

    public void setHidden(Integer hidden) {
        this.hidden = hidden;
    }

    public void setListeners(Map<ProcessEvent, List<ProcessEventListener>> listeners) {
        this.listeners = listeners;
    }

    public void setNameToListenerMap(Map<String, ProcessEventListener> nameToListenerMap) {
        this.nameToListenerMap = nameToListenerMap;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "WorkflowProcess(type=" + this.getType() + ", startEvent=" + this.getStartEvent() + ", endEvent=" + this.getEndEvent() + ", nameToTaskMap=" + this.getNameToTaskMap() + ", formClass=" + this.getFormClass() + ", processDetailHandler=" + this.getProcessDetailHandler() + ", hidden=" + this.getHidden() + ", listeners=" + this.getListeners() + ", nameToListenerMap=" + this.getNameToListenerMap() + ", version=" + this.getVersion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowProcess)) {
            return false;
        }
        WorkflowProcess other = (WorkflowProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Integer this$hidden = this.getHidden();
        Integer other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        StartEvent this$startEvent = this.getStartEvent();
        StartEvent other$startEvent = other.getStartEvent();
        if (this$startEvent == null ? other$startEvent != null : !((Object)this$startEvent).equals(other$startEvent)) {
            return false;
        }
        EndEvent this$endEvent = this.getEndEvent();
        EndEvent other$endEvent = other.getEndEvent();
        if (this$endEvent == null ? other$endEvent != null : !((Object)this$endEvent).equals(other$endEvent)) {
            return false;
        }
        Map<String, WorkflowTask> this$nameToTaskMap = this.getNameToTaskMap();
        Map<String, WorkflowTask> other$nameToTaskMap = other.getNameToTaskMap();
        if (this$nameToTaskMap == null ? other$nameToTaskMap != null : !((Object)this$nameToTaskMap).equals(other$nameToTaskMap)) {
            return false;
        }
        Class<? extends ProcessForm> this$formClass = this.getFormClass();
        Class<? extends ProcessForm> other$formClass = other.getFormClass();
        if (this$formClass == null ? other$formClass != null : !this$formClass.equals(other$formClass)) {
            return false;
        }
        ProcessDetailHandler this$processDetailHandler = this.getProcessDetailHandler();
        ProcessDetailHandler other$processDetailHandler = other.getProcessDetailHandler();
        if (this$processDetailHandler == null ? other$processDetailHandler != null : !this$processDetailHandler.equals(other$processDetailHandler)) {
            return false;
        }
        Map<ProcessEvent, List<ProcessEventListener>> this$listeners = this.getListeners();
        Map<ProcessEvent, List<ProcessEventListener>> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        Map<String, ProcessEventListener> this$nameToListenerMap = this.getNameToListenerMap();
        Map<String, ProcessEventListener> other$nameToListenerMap = other.getNameToListenerMap();
        return !(this$nameToListenerMap == null ? other$nameToListenerMap != null : !((Object)this$nameToListenerMap).equals(other$nameToListenerMap));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowProcess;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getVersion();
        Integer $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        StartEvent $startEvent = this.getStartEvent();
        result = result * 59 + ($startEvent == null ? 43 : ((Object)$startEvent).hashCode());
        EndEvent $endEvent = this.getEndEvent();
        result = result * 59 + ($endEvent == null ? 43 : ((Object)$endEvent).hashCode());
        Map<String, WorkflowTask> $nameToTaskMap = this.getNameToTaskMap();
        result = result * 59 + ($nameToTaskMap == null ? 43 : ((Object)$nameToTaskMap).hashCode());
        Class<? extends ProcessForm> $formClass = this.getFormClass();
        result = result * 59 + ($formClass == null ? 43 : $formClass.hashCode());
        ProcessDetailHandler $processDetailHandler = this.getProcessDetailHandler();
        result = result * 59 + ($processDetailHandler == null ? 43 : $processDetailHandler.hashCode());
        Map<ProcessEvent, List<ProcessEventListener>> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        Map<String, ProcessEventListener> $nameToListenerMap = this.getNameToListenerMap();
        result = result * 59 + ($nameToListenerMap == null ? 43 : ((Object)$nameToListenerMap).hashCode());
        return result;
    }

    public Map<String, WorkflowTask> getNameToTaskMap() {
        return this.nameToTaskMap;
    }
}

